﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "debug_ActivityClock.h"
#include "debug_ActivityLogViewer.h"
#include "debug_ActivityHidInputViewer.h"
#include "debug_ActivityPowerConsumptionMeter.h"
#include "debug_ActivitySystemSharedTextureViewer.h"

// 型名を列挙のこと。
#define NN_DEVOVL_FOREACH_DEBUGMODULE(macro, data)  \
    macro(Clock, data) \
    macro(LogViewer, data) \
    macro(HidInputViewer, data) \
    macro(PowerConsumptionMeter, data) \
    macro(SystemSharedTextureViewer, data) \
//

namespace scene{ namespace debug{

    // 全デバッグモジュールの Activity をまとめた構造体
    struct Activity
    {
    public:
        static const uint32_t CurrentVersion = 0;

    public:
        uint32_t version = CurrentVersion;

#define NN_DEVOVL_DEBUGMODULE_ACTIVITY(name, data)  \
        Activity##name activity##name = {};

        NN_DEVOVL_FOREACH_DEBUGMODULE(NN_DEVOVL_DEBUGMODULE_ACTIVITY, _);

#undef NN_DEVOVL_DEBUGMODULE_ACTIVITY

    };

}}
