﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/os.h>
#include "../../panel/panel_PanelContainer.h"
#include "../../panel/panel_PanelText.h"

#include "../Scene.h"

namespace scene{ namespace applaunch{

    class SceneAppLaunchParameter
    {
    public:
        explicit SceneAppLaunchParameter(nn::ncm::ApplicationId applicationId, bool* pIsHideRequested) NN_NOEXCEPT
            : m_ApplicationId(applicationId)
            , m_pIsHideRequested(pIsHideRequested)
        {
        }

        nn::ncm::ApplicationId GetApplicationId() const NN_NOEXCEPT
        {
            return m_ApplicationId;
        }

        bool* GetHideRequestedPointer() const NN_NOEXCEPT
        {
            return m_pIsHideRequested;
        }

    private:
        nn::ncm::ApplicationId m_ApplicationId;
        bool* m_pIsHideRequested;
    };

    class SceneAppLaunch
        : public Scene
    {
    public:
        static const size_t NintendoLogoDataSize = 64 * 1024;
        static const size_t StartupMovieDataSize = 64 * 1024;
        static const size_t LogoDataBufferSize = (NintendoLogoDataSize > StartupMovieDataSize) ? NintendoLogoDataSize : StartupMovieDataSize;

    public:
        explicit SceneAppLaunch(const std::shared_ptr<void>& pArg) NN_NOEXCEPT;
        virtual SceneUpdateResult Update() NN_NOEXCEPT NN_OVERRIDE;
        virtual std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT NN_OVERRIDE;

        // 最低限表示する時間を取得します。
        static nn::TimeSpan GetShownTimeMin() NN_NOEXCEPT;

    private:
        nn::Result CheckReadingApplicationLogoDataImpl() NN_NOEXCEPT;

    private:
        nn::ncm::ApplicationId m_ApplicationId;
        bool* m_pIsHideRequested;

        nn::os::Tick m_StartTick;

        std::shared_ptr<panel::PanelContainer> m_pPanelContainer;
        std::shared_ptr<panel::PanelText> m_pHeaderPanel;
        std::shared_ptr<panel::PanelText> m_pFooterPanel;

        //char m_ApplicationLogoDataBuffer[LogoDataBufferSize];

    };

}}
