﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/nn_Common.h>
#include "Scene.h"
#include "../panel/panel_IPanel.h"

namespace scene{

    class SceneStack
    {
    public:
        SceneStack() NN_NOEXCEPT;
        SceneStack(SceneIndexType initialScene, const std::shared_ptr<void>& initialArg) NN_NOEXCEPT;

        bool IsEmpty() const NN_NOEXCEPT;
        void Clear() NN_NOEXCEPT;

        void ReplaceScene(SceneIndexType scene, const std::shared_ptr<void>& arg) NN_NOEXCEPT;
        void PushScene(SceneIndexType scene, const std::shared_ptr<void>& arg) NN_NOEXCEPT;
        void PopScene() NN_NOEXCEPT;

        // シーンが切り替わる場合 true を返す。
        bool ProcessUpdateResult(const SceneUpdateResult& updateResult) NN_NOEXCEPT;

        SceneUpdateResult UpdateTopScene() NN_NOEXCEPT;
        SceneUpdateResult UpdateAllScene() NN_NOEXCEPT;

        nn::util::Color4f GetBackgroundColor() const NN_NOEXCEPT;
        void GatherPanel(std::vector<std::shared_ptr<panel::IPanel>>& list) NN_NOEXCEPT;
    private:
        std::vector<std::shared_ptr<Scene>> m_Stack;
    };


}
