﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "SceneFactory.h"

#include <nn/nn_Log.h>
#include "SceneIndex.h"
#include "overlay/SceneOverlay.h"
#include "applaunch/SceneAppLaunch.h"
#include "menu/IncludeMenuPages.h"

// MenuPage 用 case 文生成
#define NN_DETAIL_DEVOVL_CASE_MENUPAGE(item)    \
    case SceneIndex_ ## item:   \
    {                           \
        return std::make_shared<menu::Scene ## item>(pArg); \
    }

namespace scene{

    std::shared_ptr<Scene> SceneFactory::Create(SceneIndexType index, const std::shared_ptr<void>& pArg) NN_NOEXCEPT
    {
        switch(index)
        {
        case SceneIndex_Overlay:
            return std::make_shared<overlay::SceneOverlay>(pArg);
        case SceneIndex_ApplicationLogo:
            return std::make_shared<applaunch::SceneAppLaunch>(pArg);

        // Menu
        NN_DEVOVL_MENUPAGE_FOREACH(NN_DETAIL_DEVOVL_CASE_MENUPAGE)

        default:
            NN_LOG("Exiting Scene\n");
            return nullptr;
        };
    }
}
