﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "../Config.h"

#define NN_DEVOVL_FOREACH_PANELTYPE(macro)   \
    macro(Unknown)      \
    macro(Container)    \
    macro(Image)        \
    macro(Text)         \
    macro(Historical)   \
    macro(SharedTexture) \
//


enum PanelType
{
    #define NN_DEVOVL_PANELTYPE_ENUMVALUE(v) PanelType_ ## v ,
    NN_DEVOVL_FOREACH_PANELTYPE(NN_DEVOVL_PANELTYPE_ENUMVALUE)
    #undef NN_DEVOVL_PANELTYPE_ENUMVALUE
};

typedef uint32_t PanelTypeType;
