﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/nn_Common.h>
#include "panel_IPanel.h"
#include "panel_PanelBase.h"

namespace panel{

    class PanelText
        : public PanelBase<IPanel>
        , public std::enable_shared_from_this<PanelText>
    {
    public:
        PanelText() NN_NOEXCEPT;

        void SetTextPosition(float x, float y) NN_NOEXCEPT;
        void SetTextSize(float size) NN_NOEXCEPT;
        void SetTextColor(const nn::util::Color4f& color) NN_NOEXCEPT;
        void SetText(const std::string& string) NN_NOEXCEPT;

        float GetTextPositionX() const NN_NOEXCEPT;
        float GetTextPositionY() const NN_NOEXCEPT;
        float GetTextSize() const NN_NOEXCEPT;
        nn::util::Color4f GetTextColor() const NN_NOEXCEPT;
        const std::string& GetText() const NN_NOEXCEPT;

        PANEL_CAST_FUNCTION(Text);

    private:
        std::string m_Text;
        float m_TextPositionX;
        float m_TextPositionY;
        float m_TextSize;
        nn::util::Color4f m_TextColor;
    };
}
