﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "panel_PanelText.h"

namespace panel{

    PanelText::PanelText()
        : PanelBase(PanelType_Text)
        , m_TextPositionX(0)
        , m_TextPositionY(0)
        , m_TextSize(10)
        , m_TextColor(1, 1, 1, 1)
    {
    }

    void PanelText::SetTextPosition(float x, float y) NN_NOEXCEPT
    {
        if(m_TextPositionX == x && m_TextPositionY == y)
        {
            return;
        }

        NN_DEVOVL_PANEL_LOG_PANEL("p%llu:SetTextPosition(%f, %f)\n", GetPanelIdentifier(), x, y);
        m_TextPositionX = x;
        m_TextPositionY = y;
        InvalidateSelfImpl();
    }

    float PanelText::GetTextPositionX() const NN_NOEXCEPT
    {
        return m_TextPositionX;
    }

    float PanelText::GetTextPositionY() const NN_NOEXCEPT
    {
        return m_TextPositionY;
    }

    void PanelText::SetTextSize(float size) NN_NOEXCEPT
    {
        if(m_TextSize == size)
        {
            return;
        }

        NN_DEVOVL_PANEL_LOG_PANEL("p%llu:SetTextSize(%f)\n", GetPanelIdentifier(), size);
        m_TextSize = size;
        InvalidateSelfImpl();
    }

    float PanelText::GetTextSize() const NN_NOEXCEPT
    {
        return m_TextSize;
    }

    void PanelText::SetTextColor(const nn::util::Color4f& color) NN_NOEXCEPT
    {
        if(m_TextColor == color)
        {
            return;
        }

        NN_DEVOVL_PANEL_LOG_PANEL("p%llu:SetTextColor(%f,%f,%f;%f)\n", GetPanelIdentifier(), color.GetR(), color.GetG(), color.GetB(), color.GetA());
        m_TextColor = color;
        InvalidateSelfImpl();
    }

    nn::util::Color4f PanelText::GetTextColor() const NN_NOEXCEPT
    {
        return m_TextColor;
    }

    void PanelText::SetText(const std::string& str) NN_NOEXCEPT
    {
        if(m_Text == str)
        {
            return;
        }

        std::string s = str;
        s.resize(std::min<size_t>(s.size(), 10u));
        NN_DEVOVL_PANEL_LOG_PANEL("p%llu:SetText(\"%s\")\n", GetPanelIdentifier(), s.c_str());
        m_Text = str;
        InvalidateSelfImpl();
    }

    const std::string& PanelText::GetText() const NN_NOEXCEPT
    {
        return m_Text;
    }

}
