﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/gfx.h>
#include "panel_IPanel.h"
#include "detail/panel_Drawer.h"
#include "detail/panel_Renderer.h"

namespace panel{

    // Panel を管理するオブジェクト
    class PanelSystem
    {
    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void PushRenderTargetTexture(nn::gfx::Texture* pTexture) NN_NOEXCEPT;
        void RenderPanel(nn::gfx::CommandBuffer* pCommandBuffer, const std::shared_ptr<IPanel>& panel, const PanelRectangle& cropRegion) NN_NOEXCEPT;
        void SetRenderOption(const detail::RendererOption& option) NN_NOEXCEPT;
        void ResetRenderOption() NN_NOEXCEPT;

        int GetRenderedPanelCount() const NN_NOEXCEPT;

    private:
        detail::Drawer m_Drawer;
        detail::Renderer m_Renderer;

        nn::gfx::Texture* m_pCurrentRenderTargetTexture;
        nn::gfx::Texture* m_pPreviousRenderTargetTexture;

    };

    extern PanelSystem g_PanelSystem;

}
