﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "panel_PanelSystem.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

namespace panel{

    PanelSystem g_PanelSystem;

    void PanelSystem::Initialize() NN_NOEXCEPT
    {
        m_Drawer.Initilaize();
        m_Renderer.Initialize(&m_Drawer);
        m_pCurrentRenderTargetTexture = nullptr;
        m_pPreviousRenderTargetTexture = nullptr;
    }

    void PanelSystem::Finalize() NN_NOEXCEPT
    {
        m_Renderer.Finalize();
        m_Drawer.Finalize();
        m_pCurrentRenderTargetTexture = nullptr;
        m_pPreviousRenderTargetTexture = nullptr;
    }

    void PanelSystem::PushRenderTargetTexture(nn::gfx::Texture* pTexture) NN_NOEXCEPT
    {
        m_pPreviousRenderTargetTexture = m_pCurrentRenderTargetTexture;
        m_pCurrentRenderTargetTexture = pTexture;
    }

    void PanelSystem::RenderPanel(nn::gfx::CommandBuffer* pCommandBuffer, const std::shared_ptr<IPanel>& panel, const PanelRectangle& cropRegion) NN_NOEXCEPT
    {
        m_Renderer.RenderPanel(pCommandBuffer, m_pCurrentRenderTargetTexture, panel, cropRegion, m_pPreviousRenderTargetTexture);
    }

    void PanelSystem::SetRenderOption(const detail::RendererOption& option) NN_NOEXCEPT
    {
        m_Renderer.SetOption(option);
    }

    void PanelSystem::ResetRenderOption() NN_NOEXCEPT
    {
        m_Renderer.ResetOption();
    }

    int PanelSystem::GetRenderedPanelCount() const NN_NOEXCEPT
    {
        return m_Renderer.GetRenderedPanelCount();
    }

}
