﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "panel_IPanel.h"
#include "panel_PanelBase.h"

namespace framework{
    class SharedTexture;
}

namespace panel{

    class PanelSharedTexture
        : public PanelBase<IPanel>
    {
    public:
        PanelSharedTexture() NN_NOEXCEPT;

        void SetTexture(const std::shared_ptr<framework::SharedTexture>& value) NN_NOEXCEPT;
        std::shared_ptr<framework::SharedTexture> GetTexture() NN_NOEXCEPT;

        PANEL_CAST_FUNCTION(SharedTexture);

    private:
        std::shared_ptr<framework::SharedTexture> m_Texture;

    };
}
