﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "panel_PanelSharedTexture.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

namespace panel{
    PanelSharedTexture::PanelSharedTexture()
        : PanelBase(PanelType_SharedTexture)
    {
    }

    void PanelSharedTexture::SetTexture(const std::shared_ptr<framework::SharedTexture>& value) NN_NOEXCEPT
    {
        m_Texture = value;
    }

    std::shared_ptr<framework::SharedTexture> PanelSharedTexture::GetTexture() NN_NOEXCEPT
    {
        return m_Texture;
    }
}
