﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/nn_Common.h>
#include "panel_IPanel.h"
#include "panel_PanelBase.h"

namespace panel{

    class PanelContainer
        : public PanelBase<IPanelContainer>
        , public std::enable_shared_from_this<PanelContainer>
    {
    private:
        typedef PanelBase<IPanelContainer> BaseType;
    public:
        PanelContainer() NN_NOEXCEPT;
        ~PanelContainer() NN_NOEXCEPT;

        PANEL_CAST_FUNCTION(Container);

        virtual std::shared_ptr<IPanelContainer> CastToContainer() NN_NOEXCEPT NN_OVERRIDE;

        virtual int GetChildrenCount() const NN_NOEXCEPT NN_OVERRIDE;
        virtual int GetChildIndex(const std::shared_ptr<IPanel>& child) const NN_NOEXCEPT NN_OVERRIDE;
        virtual std::shared_ptr<IPanel> GetChild(int index) NN_NOEXCEPT NN_OVERRIDE;
        virtual void ClearChildren() NN_NOEXCEPT NN_OVERRIDE;
        virtual void SetChildren(const std::vector<std::shared_ptr<IPanel>>& list) NN_NOEXCEPT NN_OVERRIDE;
        virtual void AddChild(const std::shared_ptr<IPanel>& child) NN_NOEXCEPT NN_OVERRIDE;
        virtual void RemoveChild(const std::shared_ptr<IPanel>& child) NN_NOEXCEPT NN_OVERRIDE;

        virtual bool CheckRedrawRequired() const NN_NOEXCEPT NN_OVERRIDE;

    protected:
        virtual void InvalidateRecursiveImpl() NN_NOEXCEPT NN_OVERRIDE;

    private:
        std::vector<std::shared_ptr<IPanel>> m_Children;
    };

}
