﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../panel_PanelRectangle.h"

namespace panel{ namespace detail{

    class RecycleCache
    {
    public:
        RecycleCache() NN_NOEXCEPT
        {
            Invalidate();
        }

        void Invalidate() NN_NOEXCEPT
        {
            m_IsValid = false;
            m_IsForeground = false;
            m_LocalRectangle = {};
            m_GlobalRectangle = {};
        }

        void Validate(
            bool isForeground,
            const PanelRectangle& localRectangle,
            const PanelRectangle& globalRectangle
        ) NN_NOEXCEPT
        {
            m_IsValid = true;
            m_IsForeground = isForeground;
            m_LocalRectangle = localRectangle;
            m_GlobalRectangle = globalRectangle;
        }

        bool IsValid() const NN_NOEXCEPT
        {
            return m_IsValid;
        }

        bool IsForegroud() const NN_NOEXCEPT
        {
            return m_IsForeground;
        }

        const PanelRectangle& GetLocalRectangle() const NN_NOEXCEPT
        {
            return m_LocalRectangle;
        }

        const PanelRectangle& GetGlobalRectangle() const NN_NOEXCEPT
        {
            return m_GlobalRectangle;
        }

    private:
        bool m_IsValid;
        bool m_IsForeground;
        PanelRectangle m_LocalRectangle;
        PanelRectangle m_GlobalRectangle;
    };

}}
