﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "panel_Drawer.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../../framework/Framework.h"
#include "../panel_PanelFunction.h"

namespace panel{ namespace detail{

    bool Drawer::DrawWithTextWriter(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<PanelText>& pPanel,
        const PanelRectangle& cropRect
    ) NN_NOEXCEPT
    {
        auto rect = PanelFunction::GetPanelGlobalRectangle(pPanel);
        auto srect = rect.Product(cropRect);

        NN_DEVOVL_PANEL_LOG_DRAW("text rect(%d,%d;%dx%d) crop(%d,%d;%dx%d)\n", rect.x, rect.y, rect.width, rect.height, srect.x, srect.y, srect.width, srect.height);
        if(srect.IsEmpty())
        {
            return true;
        }

        auto pTextWriter = Framework::AcquirePoolTextWriter();
        if(pTextWriter == nullptr)
        {
            return false;
        }
        Framework::LockFrameCommandResource(pTextWriter);

        Framework::MakeSetViewportCommand(pCommandBuffer, reinterpret_cast<framework::Rectangle&>(rect));
        Framework::MakeSetScissorCommand(pCommandBuffer, reinterpret_cast<framework::Rectangle&>(srect));
        pCommandBuffer->SetShader(m_CommonPanelShader.GetShader(0), nn::gfx::ShaderStageBit_All);
        pCommandBuffer->SetRasterizerState(&m_CommonRasterizerState);
        pCommandBuffer->SetBlendState(m_AlphaBlendState.Get());
        pCommandBuffer->SetDepthStencilState(&m_CommonDepthStencilState);

        auto& text = pPanel->GetText();
        auto pWriter = pTextWriter->Get();
        pWriter->SetViewportSize(rect.width, rect.height);
        pWriter->SetPosition(pPanel->GetTextPositionX(), pPanel->GetTextPositionY());
        pWriter->SetColor(pPanel->GetTextColor());
        pWriter->SetFontSize(pPanel->GetTextSize());
        pWriter->Print(text.c_str());

        pTextWriter->Get()->MakeCommand(pCommandBuffer);

        return true;
    }

}}

