﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "panel_Drawer.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../../framework/Framework.h"
#include "../panel_PanelFunction.h"

namespace panel{ namespace detail{

    void Drawer::DrawWithCopyTexture(
        nn::gfx::CommandBuffer* pCommandBuffer,
        nn::gfx::Texture* pDstTexture,
        nn::gfx::Texture* pSrcTexture,
        const PanelRectangle& dstRect,
        const PanelRectangle& srcRect
    ) NN_NOEXCEPT
    {
        nn::gfx::TextureSubresource dstRegion = {};
        dstRegion.SetDefault();

        nn::gfx::TextureCopyRegion copyRegion = {};
        copyRegion.SetDefault();
        copyRegion.SetOffsetU(srcRect.x);
        copyRegion.SetOffsetV(srcRect.y);
        copyRegion.SetWidth(srcRect.width);
        copyRegion.SetHeight(srcRect.height);

        pCommandBuffer->CopyImage(pDstTexture, dstRegion, dstRect.x, dstRect.y, 0, pSrcTexture, copyRegion);
    }

}}

