﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/gfx/util/gfx_ObjectHolder.h>
#include "../../framework/ResShader.h"
#include "../../framework/ITextureView.h"
#include "../panel_IPanel.h"
#include "../panel_PanelText.h"

namespace panel{ namespace detail{

    class Drawer
    {
    public:
        void Initilaize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        int AcquireObjectIdForDebug() NN_NOEXCEPT;

        void DrawWithShader(
            nn::gfx::CommandBuffer* pCommandBuffer,
            const PanelRectangle& rect,
            const PanelRectangle& cropRect,
            const nn::util::Color4f& color,
            const std::shared_ptr<framework::ITextureView>& pTexture,
            bool isAlphaBlendEnabled
        ) NN_NOEXCEPT;

        // TextWriter が取れなかった場合 false を返す
        bool DrawWithTextWriter(
            nn::gfx::CommandBuffer* pCommandBuffer,
            const std::shared_ptr<PanelText>& pPanel,
            const PanelRectangle& cropRect
        ) NN_NOEXCEPT;

        void DrawWithCopyTexture(
            nn::gfx::CommandBuffer* pCommandBuffer,
            nn::gfx::Texture* pDstTexture,
            nn::gfx::Texture* pSrcTexture,
            const PanelRectangle& dstRect,
            const PanelRectangle& srcRect
        ) NN_NOEXCEPT;

    private:
        int                                m_NextObjectId;
        ResShader                          m_CommonPanelShader;
        nn::gfx::RasterizerState           m_CommonRasterizerState;
        nn::gfx::DepthStencilState         m_CommonDepthStencilState;

        nn::gfx::util::BlendStateHolder<1> m_SolidBlendState; // ブレンドしない。
        nn::gfx::util::BlendStateHolder<1> m_AlphaBlendState; // アルファ合成する。

    };

}}
