﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <memory>
#include <nn/nn_Common.h>
#include <nn/gfx.h>

namespace framework{

    class PoolTexture;
    class TexturePool;

    struct TexturePoolInfo
    {
        int textureWidth;
        int textureHeight;
        nn::gfx::ImageFormat textureFormat;
        int textureCount;
    };

    class TexturePool
    {
        friend class PoolTexture;
    public:
        void Initialize(const TexturePoolInfo& info) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        std::shared_ptr<PoolTexture> Acquire(int width, int height, nn::gfx::ImageFormat format) NN_NOEXCEPT;

    private:
        void InitializePoolTexture();
        void FinalizePoolTexture();
        void ReleasePoolTexture(int index) NN_NOEXCEPT;

    private:
        int m_PoolTextureWidth;
        int m_PoolTextureHeight;
        nn::gfx::ImageFormat m_PoolTextureFormat;
        int m_PoolTextureCount;

        struct Entry
        {
            bool isUsed;
        };
        std::vector<Entry> m_EntryList;

        nn::gfx::Texture        m_PoolTexture;
        nn::gfx::TextureView    m_PoolTextureView;
        nn::gfx::DescriptorSlot m_PoolTextureDescriptorSlot;
        ptrdiff_t               m_PoolTextureOffset;
        int                     m_PoolTextureDescriptorSlotIndex;
    };

    class PoolTexture
    {
        friend class TexturePool;
    public:
        PoolTexture(TexturePool* pPool, int index, int width, int height) NN_NOEXCEPT;
        ~PoolTexture() NN_NOEXCEPT;

        nn::gfx::Texture* Get() NN_NOEXCEPT;
        int GetOriginX() const NN_NOEXCEPT;
        int GetOriginY() const NN_NOEXCEPT;
        int GetWidth() const NN_NOEXCEPT;
        int GetHeight() const NN_NOEXCEPT;
        int GetPoolWidth() const NN_NOEXCEPT;
        int GetPoolHeight() const NN_NOEXCEPT;
        nn::gfx::ImageFormat GetFormat() const NN_NOEXCEPT;
        const nn::gfx::DescriptorSlot& GetDescriptorSlot() const NN_NOEXCEPT;

    private:
        static void Dispose(PoolTexture* p) NN_NOEXCEPT;

    private:
        TexturePool* m_pPool;
        int m_Index;
        int m_Width;
        int m_Height;
    };

}

