﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/vi/fbshare/vi_SharedTextureMemoryPool.h>
#include <nn/vi/fbshare/vi_SharedTexturePool.h>
#include "ITextureView.h"

namespace framework{

    class SharedTexture;

    class SharedTexturePool
    {
    public:
        SharedTexturePool() NN_NOEXCEPT;

        nn::Result Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        int GetTextureCount() const NN_NOEXCEPT;
        std::shared_ptr<SharedTexture> GetTexture(int index) NN_NOEXCEPT;

        nn::gfx::Texture* GetGfxTexture(int index) NN_NOEXCEPT;
        const nn::gfx::DescriptorSlot* GetDescriptorSlot(int index) const NN_NOEXCEPT;

    private:
#ifdef NN_DEVOVL_IS_SYSTEM
        nn::vi::fbshare::SharedTextureMemoryPool m_MemoryPool;
        nn::vi::fbshare::SharedTexturePool m_TexturePool;
#endif
        nn::vi::fbshare::SharedMemoryPoolLayout m_Layout;
        nn::gfx::Texture m_GfxTextureList[nn::vi::fbshare::SharedBufferTextureCountMax];
        nn::gfx::DescriptorSlot m_DescriptorSlotList[nn::vi::fbshare::SharedBufferTextureCountMax];
    };

    class SharedTexture
        : public ITextureView
    {
    public:
        SharedTexture(SharedTexturePool* pPool, int index) NN_NOEXCEPT;
        ~SharedTexture() NN_NOEXCEPT;

        virtual int GetPoolWidth() const NN_NOEXCEPT NN_OVERRIDE { return GetWidth(); }
        virtual int GetPoolHeight() const NN_NOEXCEPT NN_OVERRIDE { return GetHeight(); }
        virtual int GetViewOriginX() const NN_NOEXCEPT NN_OVERRIDE { return 0; }
        virtual int GetViewOriginY() const NN_NOEXCEPT NN_OVERRIDE { return 0; }
        virtual int GetViewWidth() const NN_NOEXCEPT NN_OVERRIDE { return GetWidth(); }
        virtual int GetViewHeight() const NN_NOEXCEPT NN_OVERRIDE { return GetHeight(); }
        virtual const nn::gfx::DescriptorSlot* GetTextureDescriptor() const NN_NOEXCEPT NN_OVERRIDE { return GetDescriptorSlot(); }

        const nn::gfx::Texture* Get() const NN_NOEXCEPT;
        nn::gfx::Texture* Get() NN_NOEXCEPT;
        int GetWidth() const NN_NOEXCEPT;
        int GetHeight() const NN_NOEXCEPT;
        nn::gfx::ImageFormat GetFormat() const NN_NOEXCEPT;
        const nn::gfx::DescriptorSlot* GetDescriptorSlot() const NN_NOEXCEPT;

    private:
        SharedTexturePool* m_pPool;
        int m_Index;
    };



}
