﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/gfx.h>

namespace framework{

    class ITextureView
    {
    public:
        virtual ~ITextureView() NN_NOEXCEPT
        {
        }

        virtual int GetPoolWidth() const NN_NOEXCEPT = 0;
        virtual int GetPoolHeight() const NN_NOEXCEPT = 0;
        virtual int GetViewOriginX() const NN_NOEXCEPT = 0;
        virtual int GetViewOriginY() const NN_NOEXCEPT = 0;
        virtual int GetViewWidth() const NN_NOEXCEPT = 0;
        virtual int GetViewHeight() const NN_NOEXCEPT = 0;

        virtual const nn::gfx::DescriptorSlot* GetTextureDescriptor() const NN_NOEXCEPT = 0;

    };

}
