﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

namespace framework{

    class HidHandlingModeManager
    {
    public:
        enum HandlingMode
        {
            HandlingMode_None = 0,
            HandlingMode_Interaction,
            HandlingMode_Observation,
        };

    public:

        HidHandlingModeManager() NN_NOEXCEPT;
        ~HidHandlingModeManager() NN_NOEXCEPT;

        void BeginInteraction() NN_NOEXCEPT;
        void EndInteraction() NN_NOEXCEPT;

        void BeginObservation() NN_NOEXCEPT;
        void EndObservation() NN_NOEXCEPT;

    private:
        void UpdateHandlingModeImpl() NN_NOEXCEPT;

    private:
        nn::os::Mutex m_Mutex;
        HandlingMode m_CurrentHandlingMode = HandlingMode_None;

        bool m_IsInteractionRequested = false;
        bool m_IsObservationRequested = false;
    };

    extern HidHandlingModeManager g_HidHandlingModeManager;

}
