﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "../ui/ui.h"

namespace config{

    class QuickMenuStyle
    {
    public:
        const nn::util::Color4f m_BackgroundColor = {0, 0, 0, .75f};
        const nn::util::Color4f m_BackgroundColorFocused = {.2f, .2f, 1, .75f};
        const nn::util::Color4f m_TextColor = {1, 1, 1, 1};

        const float m_TitleTextSize = 32;
        const float m_ItemTextSize = 24;

        const int m_MenuWidth = 320;
        const int m_MenuHeight = 720;
        const int m_MenuHeaderHeight = 120;
        const int m_MenuFooterHeight = 50;
        const int m_MenuButtonWidth  = 300;
        const int m_MenuButtonHeight = 80;

        // Header
        const ui::Margin m_MenuHeaderMargin = {0, 0, 0, 10};

        // Footer
        const ui::Margin        m_MenuFooterMargin = {0, 0, 0, 0}; // 罫線があるので外側にマージンをつけない
        const nn::util::Color4f m_MenuFooterLineColor = {1, 1, 1, 1};
        const ui::Size          m_MenuFooterLineSize = {m_MenuWidth * 9 / 10, 1};
        const ui::Margin        m_MenuFooterContentMargin = {0, 0, 0, 4};

        // Body
        const ui::Margin m_MenuBodyMargin = {0, 0, 0, 4};


        ui::MenuItemLabelStyle MakeTitleStyle() const NN_NOEXCEPT
        {
            auto v = ui::MenuItemLabelStyle()
                .SetBackgroundColor(ui::ItemStateFilter_Any, m_BackgroundColor)
                .SetTextStyle(ui::ItemStateFilter_Any, ui::TextStyle()
                    .SetFontColor(m_TextColor)
                    .SetFontSize(m_TitleTextSize)
                )
            ;
            return v;
        }

        ui::MenuItemLabelStyle MakeItemStyle() const NN_NOEXCEPT
        {
            auto v = ui::MenuItemLabelStyle()
                .SetBackgroundColor(ui::ItemStateFilter_Any, m_BackgroundColor)
                .SetBackgroundColor(ui::ItemStateFilter_InFocus, m_BackgroundColorFocused)
                .SetTextStyle(ui::ItemStateFilter_Any, ui::TextStyle()
                    .SetFontColor(m_TextColor)
                    .SetFontSize(m_ItemTextSize)
                )
                .SetMargin({0, 0, 0, 20})
                .SetAlignment(ui::ItemAlignment_MiddleLeft)
                .SetSizeStyle(ui::SizeStyle()
                    .SetAutoSize({m_MenuButtonWidth, m_MenuButtonHeight})
                )
            ;
            return v;
        }

        // Footer

        ui::MenuItemIconStyle MakeFooterIconStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemIconStyle()
                .SetBackgroundColor(ui::ItemStateFilter_Any, m_BackgroundColor)
                .SetIconStyle(ui::ItemStateFilter_Any, ui::IconStyle()
                    .SetIconColor({1, 1, 1, 1})
                    .SetIconSize(24)
                )
            ;
        }

        ui::MenuItemLabelStyle MakeFooterLabelStyle() const NN_NOEXCEPT
        {
            return ui::MenuItemLabelStyle()
                .SetBackgroundColor(ui::ItemStateFilter_Any, m_BackgroundColor)
                .SetTextStyle(ui::ItemStateFilter_Any, ui::TextStyle()
                    .SetFontColor({1, 1, 1, 1})
                    .SetFontSize(18)
                )
            ;
        }

        // ログのタッチ操作領域
        ui::MenuItemTableCellStyle MakeLogManipulatorCellStyle() const NN_NOEXCEPT
        {
            auto v = ui::MenuItemTableCellStyle()
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetMode(ui::BackgroundMode_InnerItem)
                )
            ;
            return v;
        }

        ui::MenuItemBoxStyle MakeLogManipulatorStyle() const NN_NOEXCEPT
        {
            auto v = ui::MenuItemBoxStyle()
                .SetSizeStyle(ui::SizeStyle()
                    .SetFixedSize({ScreenWidth, ScreenHeight})
                )
                .SetBackgroundStyle(ui::BackgroundStyle()
                    .SetMode(ui::BackgroundMode_Transparent)
                )
            ;
            return v;
        }

    };

}
