﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "RunMode.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include "Config.h"

namespace {
    bool GetBooleanSettingValue(const char* name, const char* key, bool defaultValue) NN_NOEXCEPT
    {
        bool value = false;
        auto size = nn::settings::fwdbg::GetSettingsItemValue(&value, sizeof(value), name, key);
        if(size == 0)
        {
            return defaultValue;
        }
        return value;
    }
}

void RunMode::Initialize() NN_NOEXCEPT
{
    m_IsExhibitionMode = GetBooleanSettingValue("devmenu", "enable_exhibition_mode", false);

    if(m_IsExhibitionMode)
    {
        NN_DEVOVL_LOG("Mode: Exhibition\n");
    }
    else
    {
        NN_DEVOVL_LOG("Mode: Normal\n");
    }
}

//-------------------------

bool RunMode::IsExhibitionMode() const NN_NOEXCEPT
{
    return m_IsExhibitionMode;
}

bool RunMode::IsChargerStateChangeDisplayed() const NN_NOEXCEPT
{
    return true;
}

bool RunMode::IsAudioVolumeChangeDisplayed() const NN_NOEXCEPT
{
    return true;
}

bool RunMode::IsScreenShotNotificationDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsMovieNotificationDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsHomeButtonProhibitionDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsLowBatteryNotificationDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsControllerPairingDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsControllerLowBatteryDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsControllerDisconnectionDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsPctlRemainingTimeDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsPctlSettingChangedDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsDownloadCompletionDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsContentAvailableDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsFriendNotificationDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsServerMaintenanceScheduledDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsServerMaintenanceStartDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsAccountDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

bool RunMode::IsSnapShotDumperProgressDisplayed() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}

// 通知の SE 再生設定
bool RunMode::IsNotificationSoundEffectEnabled() const NN_NOEXCEPT
{
    return !m_IsExhibitionMode;
}


