﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

layout(location = 0) out vec4 oColor;

in vec2 vTexCoord;

layout(location = 0) uniform PixelConstants
{
    vec4 iColor;
    int iIsTextureEnabled;
};
layout(location = 0) uniform sampler2D tex;

void main()
{
    if(iIsTextureEnabled != 0)
    {
        vec4 texColor = texture(tex, vTexCoord);
        oColor = texColor;
    }
    else
    {
        oColor = iColor;
    }
};
