﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/ncm/ncm_ContentMetaId.h>

#include "Config.h"
#include "ThreadMessageChannel.h"
#include "RunMode.h"

enum AppletMessage
{
    AppletMessage_None,
    AppletMessage_RequestSuspend,
    AppletMessage_RequestResume,
    AppletMessage_RequestExit,
    AppletMessage_LaunchPowerMenu,
    AppletMessage_LaunchQuickMenu,
    AppletMessage_CloseMenu,
    AppletMessage_ShowApplicationLogo,
    AppletMessage_HideApplicationLogo,
    AppletMessage_ForceHideApplicationLogo,
};

//------------------------------
// メニュー表示
//------------------------------

enum AppletMessageResponseMenuResultCode : uint16_t
{
    AppletMessageResponseMenuResultCode_None = 0,
    AppletMessageResponseMenuResultCode_Sleep,
    AppletMessageResponseMenuResultCode_Shutdown,
};

class AppletMessageMenuResponse
{
public:
    AppletMessageMenuResponse() NN_NOEXCEPT
        : m_ResultCode(AppletMessageResponseMenuResultCode_None)
    {
    }

    explicit AppletMessageMenuResponse(AppletMessageResponseMenuResultCode code) NN_NOEXCEPT
        : m_ResultCode(code)
    {
    }

    void SetResultCode(AppletMessageResponseMenuResultCode code) NN_NOEXCEPT
    {
        m_ResultCode = code;
    }

    AppletMessageResponseMenuResultCode GetResultCode() const NN_NOEXCEPT
    {
        return m_ResultCode;
    }
private:
    AppletMessageResponseMenuResultCode m_ResultCode;
};

//------------------------------------
// アプリ起動ロゴ表示
//------------------------------------

class AppletMessageApplicationLogoInfo
{
public:
    AppletMessageApplicationLogoInfo() NN_NOEXCEPT
        : m_ApplicationId()
    {
    }

    void SetApplicationId(nn::ncm::ApplicationId value) NN_NOEXCEPT
    {
        m_ApplicationId = value;
    }

    nn::ncm::ApplicationId GetApplicationId() const NN_NOEXCEPT
    {
        return m_ApplicationId;
    }

private:
    nn::ncm::ApplicationId m_ApplicationId;
};


//------------------------------------
// スレッド
//------------------------------------

struct AppletMessageThreadParameter
{
    nn::os::SystemEventType* pMessageReceivedEvent;
    ThreadMessageChannel* pToOverlayDisplayChannel;
    ThreadMessageChannel* pToOverlayNotificationChannel;
    RunMode* pRunMode;
};

void AppletMessageThreadFunction(void* pArg) NN_NOEXCEPT;
