﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <glv_core.h>
#include <nn/fs/fs_SaveDataTypes.h>

namespace devmenu { namespace savedata {

    struct DataMoveInfo
    {
        struct SaveDataTypeDirectoryInfo
        {
            nn::fs::SaveDataType type;
            std::string name;
        };

        static const std::string                 ExportPathRoot;
        static const std::string                 ConfigFileName;
        static const SaveDataTypeDirectoryInfo   TypeDirectoryInfo[ 6 ];
        static const std::string                 ExportedSaveDataInfoFileName;

#if defined ( NN_CUSTOMERSUPPORTTOOL )

        static const std::string NsaveFilenameExtension;
        static const int ConfigXmlRootPathStringSize;
        static const int XmlFileCount;
        static const int64_t NsaveFileMaxSize;

        // インポートディレクトリ形式サイズ定義
        // yyyymmddhhmmss_<ApplicationId>/user/<ApplicationId>/XXXX/
        static const size_t SaveDataDateStrLength;
        static const size_t SaveDataApplicationIdStrLength;
        static const size_t UserStrLength;
        static const size_t NumberingStrLength;
        static const size_t DirectoryStrLength;

        // 規定ディレクトリを抽出するためのディレクトリ階層
        static const int DirectorySearchPosition;

        // 相対パスを抽出するためのディレクトリ階層
        static const int RelativePathPosition;

        // マウントポイントの区切り文字列 ":/"
        static const int MountDelimiterStrLength;

#endif
    };

    struct Default
    {
        static const float FontSize;
        static const float FontSizeSmall;
        static const float FontSizeMedium;
        static const int   MaxApplicationNameLength;

        static const float ButtonHeight;
        static const float ButtonWidthBack;
        static const float ButtonWidthExport;
        static const float ButtonWidthVerify;
        static const float ButtonWidthDelete;
        static const float ButtonWidthCorrupt;
        static const float ButtonWidthExportRaw;
        static const float PlacerOffsetHorizontal;
        static const float PlacerOffsetVertical;

        static const glv::space_t HeaderRegion;
        static const glv::space_t FooterRegion;
        static const glv::space_t ListMarginLeft;
        static const glv::space_t ListMarginRight;

        static const char* ApplicationIdStatementFormat;
        static const char* SaveDataIdStatementFormat;
    };

}} // ~namespace devmenu::savedata, ~namespace devmenu
