﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * インクルード
 */
#include "QREL.h"

/*
 * 定数
 */
enum ConstantValue_Version
{
    VersionMaxNum  = 40,   /* 型番最大使用数 */
    ErrorCorrectLevelNum = 4,    /* 誤り訂正レベル数 M:0,L:1,H:2,Q:3 */
};

/*
 * 構造体定義
 */

/* 型番ごとの情報テーブル */
typedef struct {
    short AllDataWordNum;                   /* 総コード語数                */
    uint8_t CellNum;                        /* 一辺のセル数                */
    int8_t POPNum;                          /* 位置合わせパターン数        */
    ERRCORUNIT ErrcorUnit[ErrorCorrectLevelNum];  /* 誤り訂正レベル毎のデータ    */
    uint8_t POPCoordX[PopMaxNum];           /* 位置合わせパターン座標Ｘ    */
    uint8_t POPCoordY[PopMaxNum];           /* 位置合わせパターン座標Ｙ    */
} VERSIONTABLE;

/*
 * 外部変数定義
 */
static const VERSIONTABLE versiontable[VersionMaxNum] = {
    { 26, 21, 0, {{ 10, 1, 1, 0, {{ 26, 16, 4 }, { 0, 0, 0 }}}, { 7, 1, 1, 0, {{ 26, 19, 2 }, { 0, 0, 0 }}}, { 17, 1, 1, 0, {{ 26, 9, 8 }, { 0, 0, 0 }}}, { 13, 1, 1, 0, {{ 26, 13, 6 }, { 0, 0, 0 }}}}, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 44, 25, 1, {{ 16, 1, 1, 0, {{ 44, 28, 8 }, { 0, 0, 0 }}}, { 10, 1, 1, 0, {{ 44, 34, 4 }, { 0, 0, 0 }}}, { 28, 1, 1, 0, {{ 44, 16, 14 }, { 0, 0, 0 }}}, { 22, 1, 1, 0, {{ 44, 22, 11 }, { 0, 0, 0 }}}}, { 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 70, 29, 1, {{ 26, 1, 1, 0, {{ 70, 44, 13 }, { 0, 0, 0 }}}, { 15, 1, 1, 0, {{ 70, 55, 7 }, { 0, 0, 0 }}}, { 44, 2, 2, 0, {{ 35, 13, 11 }, { 0, 0, 0 }}}, { 36, 2, 2, 0, {{ 35, 17, 9 }, { 0, 0, 0 }}}}, { 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 100, 33, 1, {{ 36, 2, 2, 0, {{ 50, 32, 9 }, { 0, 0, 0 }}}, { 20, 1, 1, 0, {{ 100, 80, 10 }, { 0, 0, 0 }}}, { 64, 4, 4, 0, {{ 25, 9, 8 }, { 0, 0, 0 }}}, { 52, 2, 2, 0, {{ 50, 24, 13 }, { 0, 0, 0 }}}}, { 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 134, 37, 1, {{ 48, 2, 2, 0, {{ 67, 43, 12 }, { 0, 0, 0 }}}, { 26, 1, 1, 0, {{ 134, 108, 13 }, { 0, 0, 0 }}}, { 88, 4, 2, 2, {{ 33, 11, 11 }, { 34, 12, 11 }}}, { 72, 4, 2, 2, {{ 33, 15, 9 }, { 34, 16, 9 }}}}, { 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 172, 41, 1, {{ 64, 4, 4, 0, {{ 43, 27, 8 }, { 0, 0, 0 }}}, { 36, 2, 2, 0, {{ 86, 68, 9 }, { 0, 0, 0 }}}, { 112, 4, 4, 0, {{ 43, 15, 14 }, { 0, 0, 0 }}}, { 96, 4, 4, 0, {{ 43, 19, 12 }, { 0, 0, 0 }}}}, { 34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 196, 45, 6, {{ 72, 4, 4, 0, {{ 49, 31, 9 }, { 0, 0, 0 }}}, { 40, 2, 2, 0, {{ 98, 78, 10 }, { 0, 0, 0 }}}, { 130, 5, 4, 1, {{ 39, 13, 13 }, { 40, 14, 13 }}}, { 108, 6, 2, 4, {{ 32, 14, 9 }, { 33, 15, 9 }}}}, { 6, 22, 22, 22, 38, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 22, 6, 22, 38, 22, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 242, 49, 6, {{ 88, 4, 2, 2, {{ 60, 38, 11 }, { 61, 39, 11 }}}, { 48, 2, 2, 0, {{ 121, 97, 12 }, { 0, 0, 0 }}}, { 156, 6, 4, 2, {{ 40, 14, 13 }, { 41, 15, 13 }}}, { 132, 6, 4, 2, {{ 40, 18, 11 }, { 41, 19, 11 }}}}, { 6, 24, 24, 24, 42, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 24, 6, 24, 42, 24, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 292, 53, 6, {{ 110, 5, 3, 2, {{ 58, 36, 11 }, { 59, 37, 11 }}}, { 60, 2, 2, 0, {{ 146, 116, 15 }, { 0, 0, 0 }}}, { 192, 8, 4, 4, {{ 36, 12, 12 }, { 37, 13, 12 }}}, { 160, 8, 4, 4, {{ 36, 16, 10 }, { 37, 17, 10 }}}}, { 6, 26, 26, 26, 46, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 26, 6, 26, 46, 26, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 346, 57, 6, {{ 130, 5, 4, 1, {{ 69, 43, 13 }, { 70, 44, 13 }}}, { 72, 4, 2, 2, {{ 86, 68, 9 }, { 87, 69, 9 }}}, { 224, 8, 6, 2, {{ 43, 15, 14 }, { 44, 16, 14 }}}, { 192, 8, 6, 2, {{ 43, 19, 12 }, { 44, 20, 12 }}}}, { 6, 28, 28, 28, 50, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 28, 6, 28, 50, 28, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 404, 61, 6, {{ 150, 5, 1, 4, {{ 80, 50, 15 }, { 81, 51, 15 }}}, { 80, 4, 4, 0, {{ 101, 81, 10 }, { 0, 0, 0 }}}, { 264, 11, 3, 8, {{ 36, 12, 12 }, { 37, 13, 12 }}}, { 224, 8, 4, 4, {{ 50, 22, 14 }, { 51, 23, 14 }}}}, { 6, 30, 30, 30, 54, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 30, 6, 30, 54, 30, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 466, 65, 6, {{ 176, 8, 6, 2, {{ 58, 36, 11 }, { 59, 37, 11 }}}, { 96, 4, 2, 2, {{ 116, 92, 12 }, { 117, 93, 12 }}}, { 308, 11, 7, 4, {{ 42, 14, 14 }, { 43, 15, 14 }}}, { 260, 10, 4, 6, {{ 46, 20, 13 }, { 47, 21, 13 }}}}, { 6, 32, 32, 32, 58, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 32, 6, 32, 58, 32, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 532, 69, 6, {{ 198, 9, 8, 1, {{ 59, 37, 11 }, { 60, 38, 11 }}}, { 104, 4, 4, 0, {{ 133, 107, 13 }, { 0, 0, 0 }}}, { 352, 16, 12, 4, {{ 33, 11, 11 }, { 34, 12, 11 }}}, { 288, 12, 8, 4, {{ 44, 20, 12 }, { 45, 21, 12 }}}}, { 6, 34, 34, 34, 62, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 34, 6, 34, 62, 34, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 581, 73, 13, {{ 216, 9, 4, 5, {{ 64, 40, 12 }, { 65, 41, 12 }}}, { 120, 4, 3, 1, {{ 145, 115, 15 }, { 146, 116, 15 }}}, { 384, 16, 11, 5, {{ 36, 12, 12 }, { 37, 13, 12 }}}, { 320, 16, 11, 5, {{ 36, 16, 10 }, { 37, 17, 10 }}}}, { 6, 6, 26, 26, 26, 26, 46, 46, 46, 46, 66, 66, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 26, 46, 6, 26, 46, 66, 6, 26, 46, 66, 26, 46, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 655, 77, 13, {{ 240, 10, 5, 5, {{ 65, 41, 12 }, { 66, 42, 12 }}}, { 132, 6, 5, 1, {{ 109, 87, 11 }, { 110, 88, 11 }}}, { 432, 18, 11, 7, {{ 36, 12, 12 }, { 37, 13, 12 }}}, { 360, 12, 5, 7, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 26, 26, 26, 26, 48, 48, 48, 48, 70, 70, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 26, 48, 6, 26, 48, 70, 6, 26, 48, 70, 26, 48, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 733, 81, 13, {{ 280, 10, 7, 3, {{ 73, 45, 14 }, { 74, 46, 14 }}}, { 144, 6, 5, 1, {{ 122, 98, 12 }, { 123, 99, 12 }}}, { 480, 16, 3, 13, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 408, 17, 15, 2, {{ 43, 19, 12 }, { 44, 20, 12 }}}}, { 6, 6, 26, 26, 26, 26, 50, 50, 50, 50, 74, 74, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 26, 50, 6, 26, 50, 74, 6, 26, 50, 74, 26, 50, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 815, 85, 13, {{ 308, 11, 10, 1, {{ 74, 46, 14 }, { 75, 47, 14 }}}, { 168, 6, 1, 5, {{ 135, 107, 14 }, { 136, 108, 14 }}}, { 532, 19, 2, 17, {{ 42, 14, 14 }, { 43, 15, 14 }}}, { 448, 16, 1, 15, {{ 50, 22, 14 }, { 51, 23, 14 }}}}, { 6, 6, 30, 30, 30, 30, 54, 54, 54, 54, 78, 78, 78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 30, 54, 6, 30, 54, 78, 6, 30, 54, 78, 30, 54, 78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 901, 89, 13, {{ 338, 13, 9, 4, {{ 69, 43, 13 }, { 70, 44, 13 }}}, { 180, 6, 5, 1, {{ 150, 120, 15 }, { 151, 121, 15 }}}, { 588, 21, 2, 19, {{ 42, 14, 14 }, { 43, 15, 14 }}}, { 504, 18, 17, 1, {{ 50, 22, 14 }, { 51, 23, 14 }}}}, { 6, 6, 30, 30, 30, 30, 56, 56, 56, 56, 82, 82, 82, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 30, 56, 6, 30, 56, 82, 6, 30, 56, 82, 30, 56, 82, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 991, 93, 13, {{ 364, 14, 3, 11, {{ 70, 44, 13 }, { 71, 45, 13 }}}, { 196, 7, 3, 4, {{ 141, 113, 14 }, { 142, 114, 14 }}}, { 650, 25, 9, 16, {{ 39, 13, 13 }, { 40, 14, 13 }}}, { 546, 21, 17, 4, {{ 47, 21, 13 }, { 48, 22, 13 }}}}, { 6, 6, 30, 30, 30, 30, 58, 58, 58, 58, 86, 86, 86, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 30, 58, 6, 30, 58, 86, 6, 30, 58, 86, 30, 58, 86, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 1085, 97, 13, {{ 416, 16, 3, 13, {{ 67, 41, 13 }, { 68, 42, 13 }}}, { 224, 8, 3, 5, {{ 135, 107, 14 }, { 136, 108, 14 }}}, { 700, 25, 15, 10, {{ 43, 15, 14 }, { 44, 16, 14 }}}, { 600, 20, 15, 5, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 34, 34, 34, 34, 62, 62, 62, 62, 90, 90, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 34, 62, 6, 34, 62, 90, 6, 34, 62, 90, 34, 62, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 1156, 101, 22, {{ 442, 17, 17, 0, {{ 68, 42, 13 }, { 0, 0, 0 }}}, { 224, 8, 4, 4, {{ 144, 116, 14 }, { 145, 117, 14 }}}, { 750, 25, 19, 6, {{ 46, 16, 15 }, { 47, 17, 15 }}}, { 644, 23, 17, 6, {{ 50, 22, 14 }, { 51, 23, 14 }}}}, { 6, 6, 6, 28, 28, 28, 28, 28, 50, 50, 50, 50, 50, 72, 72, 72, 72, 72, 94, 94, 94, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 28, 50, 72, 6, 28, 50, 72, 94, 6, 28, 50, 72, 94, 6, 28, 50, 72, 94, 28, 50, 72, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 1258, 105, 22, {{ 476, 17, 17, 0, {{ 74, 46, 14 }, { 0, 0, 0 }}}, { 252, 9, 2, 7, {{ 139, 111, 14 }, { 140, 112, 14 }}}, { 816, 34, 34, 0, {{ 37, 13, 12 }, { 0, 0, 0 }}}, { 690, 23, 7, 16, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 26, 26, 26, 26, 26, 50, 50, 50, 50, 50, 74, 74, 74, 74, 74, 98, 98, 98, 98, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 26, 50, 74, 6, 26, 50, 74, 98, 6, 26, 50, 74, 98, 6, 26, 50, 74, 98, 26, 50, 74, 98, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 1364, 109, 22, {{ 504, 18, 4, 14, {{ 75, 47, 14 }, { 76, 48, 14 }}}, { 270, 9, 4, 5, {{ 151, 121, 15 }, { 152, 122, 15 }}}, { 900, 30, 16, 14, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 750, 25, 11, 14, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 30, 30, 30, 30, 30, 54, 54, 54, 54, 54, 78, 78, 78, 78, 78, 102, 102, 102, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 30, 54, 78, 6, 30, 54, 78, 102, 6, 30, 54, 78, 102, 6, 30, 54, 78, 102, 30, 54, 78, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 1474, 113, 22, {{ 560, 20, 6, 14, {{ 73, 45, 14 }, { 74, 46, 14 }}}, { 300, 10, 6, 4, {{ 147, 117, 15 }, { 148, 118, 15 }}}, { 960, 32, 30, 2, {{ 46, 16, 15 }, { 47, 17, 15 }}}, { 810, 27, 11, 16, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 28, 28, 28, 28, 28, 54, 54, 54, 54, 54, 80, 80, 80, 80, 80, 106, 106, 106, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 28, 54, 80, 6, 28, 54, 80, 106, 6, 28, 54, 80, 106, 6, 28, 54, 80, 106, 28, 54, 80, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 1588, 117, 22, {{ 588, 21, 8, 13, {{ 75, 47, 14 }, { 76, 48, 14 }}}, { 312, 12, 8, 4, {{ 132, 106, 13 }, { 133, 107, 13 }}}, { 1050, 35, 22, 13, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 870, 29, 7, 22, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 32, 32, 32, 32, 32, 58, 58, 58, 58, 58, 84, 84, 84, 84, 84, 110, 110, 110, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 32, 58, 84, 6, 32, 58, 84, 110, 6, 32, 58, 84, 110, 6, 32, 58, 84, 110, 32, 58, 84, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 1706, 121, 22, {{ 644, 23, 19, 4, {{ 74, 46, 14 }, { 75, 47, 14 }}}, { 336, 12, 10, 2, {{ 142, 114, 14 }, { 143, 115, 14 }}}, { 1110, 37, 33, 4, {{ 46, 16, 15 }, { 47, 17, 15 }}}, { 952, 34, 28, 6, {{ 50, 22, 14 }, { 51, 23, 14 }}}}, { 6, 6, 6, 30, 30, 30, 30, 30, 58, 58, 58, 58, 58, 86, 86, 86, 86, 86, 114, 114, 114, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 30, 58, 86, 6, 30, 58, 86, 114, 6, 30, 58, 86, 114, 6, 30, 58, 86, 114, 30, 58, 86, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 1828, 125, 22, {{ 700, 25, 22, 3, {{ 73, 45, 14 }, { 74, 46, 14 }}}, { 360, 12, 8, 4, {{ 152, 122, 15 }, { 153, 123, 15 }}}, { 1200, 40, 12, 28, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1020, 34, 8, 26, {{ 53, 23, 15 }, { 54, 24, 15 }}}}, { 6, 6, 6, 34, 34, 34, 34, 34, 62, 62, 62, 62, 62, 90, 90, 90, 90, 90, 118, 118, 118, 118, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 34, 62, 90, 6, 34, 62, 90, 118, 6, 34, 62, 90, 118, 6, 34, 62, 90, 118, 34, 62, 90, 118, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 1921, 129, 33, {{ 728, 26, 3, 23, {{ 73, 45, 14 }, { 74, 46, 14 }}}, { 390, 13, 3, 10, {{ 147, 117, 15 }, { 148, 118, 15 }}}, { 1260, 42, 11, 31, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1050, 35, 4, 31, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 26, 26, 26, 26, 26, 26, 50, 50, 50, 50, 50, 50, 74, 74, 74, 74, 74, 74, 98, 98, 98, 98, 98, 98, 122, 122, 122, 122, 122, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 26, 50, 74, 98, 6, 26, 50, 74, 98, 122, 6, 26, 50, 74, 98, 122, 6, 26, 50, 74, 98, 122, 6, 26, 50, 74, 98, 122, 26, 50, 74, 98, 122, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 2051, 133, 33, {{ 784, 28, 21, 7, {{ 73, 45, 14 }, { 74, 46, 14 }}}, { 420, 14, 7, 7, {{ 146, 116, 15 }, { 147, 117, 15 }}}, { 1350, 45, 19, 26, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1140, 38, 1, 37, {{ 53, 23, 15 }, { 54, 24, 15 }}}}, { 6, 6, 6, 6, 30, 30, 30, 30, 30, 30, 54, 54, 54, 54, 54, 54, 78, 78, 78, 78, 78, 78, 102, 102, 102, 102, 102, 102, 126, 126, 126, 126, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 30, 54, 78, 102, 6, 30, 54, 78, 102, 126, 6, 30, 54, 78, 102, 126, 6, 30, 54, 78, 102, 126, 6, 30, 54, 78, 102, 126, 30, 54, 78, 102, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 2185, 137, 33, {{ 812, 29, 19, 10, {{ 75, 47, 14 }, { 76, 48, 14 }}}, { 450, 15, 5, 10, {{ 145, 115, 15 }, { 146, 116, 15 }}}, { 1440, 48, 23, 25, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1200, 40, 15, 25, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 26, 26, 26, 26, 26, 26, 52, 52, 52, 52, 52, 52, 78, 78, 78, 78, 78, 78, 104, 104, 104, 104, 104, 104, 130, 130, 130, 130, 130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 26, 52, 78, 104, 6, 26, 52, 78, 104, 130, 6, 26, 52, 78, 104, 130, 6, 26, 52, 78, 104, 130, 6, 26, 52, 78, 104, 130, 26, 52, 78, 104, 130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 2323, 141, 33, {{ 868, 31, 2, 29, {{ 74, 46, 14 }, { 75, 47, 14 }}}, { 480, 16, 13, 3, {{ 145, 115, 15 }, { 146, 116, 15 }}}, { 1530, 51, 23, 28, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1290, 43, 42, 1, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 30, 30, 30, 30, 30, 30, 56, 56, 56, 56, 56, 56, 82, 82, 82, 82, 82, 82, 108, 108, 108, 108, 108, 108, 134, 134, 134, 134, 134, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 30, 56, 82, 108, 6, 30, 56, 82, 108, 134, 6, 30, 56, 82, 108, 134, 6, 30, 56, 82, 108, 134, 6, 30, 56, 82, 108, 134, 30, 56, 82, 108, 134, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 2465, 145, 33, {{ 924, 33, 10, 23, {{ 74, 46, 14 }, { 75, 47, 14 }}}, { 510, 17, 17, 0, {{ 145, 115, 15 }, { 0, 0, 0 }}}, { 1620, 54, 19, 35, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1350, 45, 10, 35, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 34, 34, 34, 34, 34, 34, 60, 60, 60, 60, 60, 60, 86, 86, 86, 86, 86, 86, 112, 112, 112, 112, 112, 112, 138, 138, 138, 138, 138, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 34, 60, 86, 112, 6, 34, 60, 86, 112, 138, 6, 34, 60, 86, 112, 138, 6, 34, 60, 86, 112, 138, 6, 34, 60, 86, 112, 138, 34, 60, 86, 112, 138, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 2611, 149, 33, {{ 980, 35, 14, 21, {{ 74, 46, 14 }, { 75, 47, 14 }}}, { 540, 18, 17, 1, {{ 145, 115, 15 }, { 146, 116, 15 }}}, { 1710, 57, 11, 46, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1440, 48, 29, 19, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 30, 30, 30, 30, 30, 30, 58, 58, 58, 58, 58, 58, 86, 86, 86, 86, 86, 86, 114, 114, 114, 114, 114, 114, 142, 142, 142, 142, 142, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 30, 58, 86, 114, 6, 30, 58, 86, 114, 142, 6, 30, 58, 86, 114, 142, 6, 30, 58, 86, 114, 142, 6, 30, 58, 86, 114, 142, 30, 58, 86, 114, 142, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 2761, 153, 33, {{ 1036, 37, 14, 23, {{ 74, 46, 14 }, { 75, 47, 14 }}}, { 570, 19, 13, 6, {{ 145, 115, 15 }, { 146, 116, 15 }}}, { 1800, 60, 59, 1, {{ 46, 16, 15 }, { 47, 17, 15 }}}, { 1530, 51, 44, 7, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 34, 34, 34, 34, 34, 34, 62, 62, 62, 62, 62, 62, 90, 90, 90, 90, 90, 90, 118, 118, 118, 118, 118, 118, 146, 146, 146, 146, 146, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 34, 62, 90, 118, 6, 34, 62, 90, 118, 146, 6, 34, 62, 90, 118, 146, 6, 34, 62, 90, 118, 146, 6, 34, 62, 90, 118, 146, 34, 62, 90, 118, 146, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }},
    { 2876, 157, 46, {{ 1064, 38, 12, 26, {{ 75, 47, 14 }, { 76, 48, 14 }}}, { 570, 19, 12, 7, {{ 151, 121, 15 }, { 152, 122, 15 }}}, { 1890, 63, 22, 41, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1590, 53, 39, 14, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 6, 30, 30, 30, 30, 30, 30, 30, 54, 54, 54, 54, 54, 54, 54, 78, 78, 78, 78, 78, 78, 78, 102, 102, 102, 102, 102, 102, 102, 126, 126, 126, 126, 126, 126, 126, 150, 150, 150, 150, 150, 150 }, { 30, 54, 78, 102, 126, 6, 30, 54, 78, 102, 126, 150, 6, 30, 54, 78, 102, 126, 150, 6, 30, 54, 78, 102, 126, 150, 6, 30, 54, 78, 102, 126, 150, 6, 30, 54, 78, 102, 126, 150, 30, 54, 78, 102, 126, 150 }},
    { 3034, 161, 46, {{ 1120, 40, 6, 34, {{ 75, 47, 14 }, { 76, 48, 14 }}}, { 600, 20, 6, 14, {{ 151, 121, 15 }, { 152, 122, 15 }}}, { 1980, 66, 2, 64, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1680, 56, 46, 10, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 6, 24, 24, 24, 24, 24, 24, 24, 50, 50, 50, 50, 50, 50, 50, 76, 76, 76, 76, 76, 76, 76, 102, 102, 102, 102, 102, 102, 102, 128, 128, 128, 128, 128, 128, 128, 154, 154, 154, 154, 154, 154 }, { 24, 50, 76, 102, 128, 6, 24, 50, 76, 102, 128, 154, 6, 24, 50, 76, 102, 128, 154, 6, 24, 50, 76, 102, 128, 154, 6, 24, 50, 76, 102, 128, 154, 6, 24, 50, 76, 102, 128, 154, 24, 50, 76, 102, 128, 154 }},
    { 3196, 165, 46, {{ 1204, 43, 29, 14, {{ 74, 46, 14 }, { 75, 47, 14 }}}, { 630, 21, 17, 4, {{ 152, 122, 15 }, { 153, 123, 15 }}}, { 2100, 70, 24, 46, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1770, 59, 49, 10, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 6, 28, 28, 28, 28, 28, 28, 28, 54, 54, 54, 54, 54, 54, 54, 80, 80, 80, 80, 80, 80, 80, 106, 106, 106, 106, 106, 106, 106, 132, 132, 132, 132, 132, 132, 132, 158, 158, 158, 158, 158, 158 }, { 28, 54, 80, 106, 132, 6, 28, 54, 80, 106, 132, 158, 6, 28, 54, 80, 106, 132, 158, 6, 28, 54, 80, 106, 132, 158, 6, 28, 54, 80, 106, 132, 158, 6, 28, 54, 80, 106, 132, 158, 28, 54, 80, 106, 132, 158 }},
    { 3362, 169, 46, {{ 1260, 45, 13, 32, {{ 74, 46, 14 }, { 75, 47, 14 }}}, { 660, 22, 4, 18, {{ 152, 122, 15 }, { 153, 123, 15 }}}, { 2220, 74, 42, 32, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1860, 62, 48, 14, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 6, 32, 32, 32, 32, 32, 32, 32, 58, 58, 58, 58, 58, 58, 58, 84, 84, 84, 84, 84, 84, 84, 110, 110, 110, 110, 110, 110, 110, 136, 136, 136, 136, 136, 136, 136, 162, 162, 162, 162, 162, 162 }, { 32, 58, 84, 110, 136, 6, 32, 58, 84, 110, 136, 162, 6, 32, 58, 84, 110, 136, 162, 6, 32, 58, 84, 110, 136, 162, 6, 32, 58, 84, 110, 136, 162, 6, 32, 58, 84, 110, 136, 162, 32, 58, 84, 110, 136, 162 }},
    { 3532, 173, 46, {{ 1316, 47, 40, 7, {{ 75, 47, 14 }, { 76, 48, 14 }}}, { 720, 24, 20, 4, {{ 147, 117, 15 }, { 148, 118, 15 }}}, { 2310, 77, 10, 67, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 1950, 65, 43, 22, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 6, 26, 26, 26, 26, 26, 26, 26, 54, 54, 54, 54, 54, 54, 54, 82, 82, 82, 82, 82, 82, 82, 110, 110, 110, 110, 110, 110, 110, 138, 138, 138, 138, 138, 138, 138, 166, 166, 166, 166, 166, 166 }, { 26, 54, 82, 110, 138, 6, 26, 54, 82, 110, 138, 166, 6, 26, 54, 82, 110, 138, 166, 6, 26, 54, 82, 110, 138, 166, 6, 26, 54, 82, 110, 138, 166, 6, 26, 54, 82, 110, 138, 166, 26, 54, 82, 110, 138, 166 }},
    { 3706, 177, 46, {{ 1372, 49, 18, 31, {{ 75, 47, 14 }, { 76, 48, 14 }}}, { 750, 25, 19, 6, {{ 148, 118, 15 }, { 149, 119, 15 }}}, { 2430, 81, 20, 61, {{ 45, 15, 15 }, { 46, 16, 15 }}}, { 2040, 68, 34, 34, {{ 54, 24, 15 }, { 55, 25, 15 }}}}, { 6, 6, 6, 6, 6, 30, 30, 30, 30, 30, 30, 30, 58, 58, 58, 58, 58, 58, 58, 86, 86, 86, 86, 86, 86, 86, 114, 114, 114, 114, 114, 114, 114, 142, 142, 142, 142, 142, 142, 142, 170, 170, 170, 170, 170, 170 }, { 30, 58, 86, 114, 142, 6, 30, 58, 86, 114, 142, 170, 6, 30, 58, 86, 114, 142, 170, 6, 30, 58, 86, 114, 142, 170, 6, 30, 58, 86, 114, 142, 170, 6, 30, 58, 86, 114, 142, 170, 30, 58, 86, 114, 142, 170 }}
};

/****************************************************************
 * 外部関数
 ****************************************************************/
/*
 * 関数名 VER_GetAllDataWord
 * 機能   型番に定義された総データワード数を返す
 * 引数   version(IN)             型番
 *        pAllDataWord(OUT)         総データワード数
 * 戻り値 正常終了時0以外を異常終了時（未対応型番時）0を返す
 *
 */
bool VER_GetAllDataWord(int32_t version, int32_t *pAllDataWordNum)
{
    if (version > VersionMaxNum)
        return false;
    else {
        *pAllDataWordNum = (int32_t)versiontable[version - 1].AllDataWordNum;
        return true;
    }
}

/*
 * 関数名 VER_GetPOPCoord
 * 機能   型番に定義された位置合わせパターン情報を返す
 * 引数   (IN)    型番
 *        (OUT)   位置合わせパターン数
 *        (OUT)   位置合わせパターンＸ座標格納配列
 *        (OUT)   位置合わせパターンＹ座標格納配列
 * 戻り値 正常終了時0以外を異常終了時（未対応型番時）0を返す
 *
 */
bool VER_GetPOPCoord(int32_t version, int32_t *popnum, int32_t *xarray, int32_t *yarray)
{
    int32_t i = 0;
    if (version > VersionMaxNum)
        return false;
    else {
        *popnum = versiontable[version - 1].POPNum;
        for (i = 0; i < PopMaxNum; i++) {
            xarray[i] = (int32_t)versiontable[version - 1].POPCoordX[i];
            yarray[i] = (int32_t)versiontable[version - 1].POPCoordY[i];
        }
        return true;
    }
}

/*
 * 関数名 VER_GetRSInfo
 * 機能   型番・誤り訂正レベル毎に定義されたRSブロック情報を返す
 * 引数   version(IN)    型番
 *        ecclevel(IN)   型番
 *        rsinfo(OUT)    RSブロックの型情報
 * 戻り値 正常終了時0以外を異常終了時（未対応型番時）0を返す
 *
 */
bool VER_GetRSInfo(int32_t version, ECCLEVEL ecclevel, ERRCORUNIT *rsinfo)
{
    if (version > VersionMaxNum)
        return false;
    else {
        *rsinfo = versiontable[version - 1].ErrcorUnit[ecclevel];
        return true;
    }
}

/*
 * 関数名 VER_GetnCellNum
 * 機能   型番毎に定義された一辺のセル数情報を返す
 * 引数   version(IN)    型番
 *        cellnum(OUT)   一辺のセル数
 * 戻り値 正常終了時0以外を異常終了時（未対応型番時）0を返す
 *
 */
bool VER_GetnCellNum(int32_t version, int32_t *cellnum)
{
    if (version > VersionMaxNum)
        return false;
    else {
        *cellnum = versiontable[version - 1].CellNum;
        return true;
    }
}

/*
 * 関数名 VER_GetMaxVersion
 * 機能   最大型番を取得する
 * 引数   なし
 * 戻り値 最大型番を返す
 * 説明      最大型番を取得する
 *
 */
int32_t VER_GetMaxVersion()
{
    return VersionMaxNum;
}
