﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>

#include "QREL.h"

int32_t E;

static const int32_t PP[] = { 1, 0, 1, 1, 1, 0, 0, 0, 1 };

static const int8_t gp10[] = { 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1 };
static const int8_t gp12[] = { 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1 };

static int32_t B0;
static int32_t alpha[256];
static int32_t indexes[256];
static int32_t gg[31];

static int32_t modnn(int32_t x)
{
    while (x >= 255) {
        x -= 255;
        x = (x >> 8) + (x & 255);
    }
    return x;
}

void init_rs(int32_t e, int32_t b0)
{
    E = e;
    // KK = 255 - e;
    B0 = b0;
    int32_t mask = 1;
    alpha[8] = 0;

    for (int32_t i = 0; i < 8; i++) {
        alpha[i] = mask;
        indexes[alpha[i]] = i;
        if (PP[i] != 0)
            alpha[8] ^= mask;
        mask <<= 1;
    }
    indexes[alpha[8]] = 8;
    mask >>= 1;
    for (int32_t i = 9; i < 255; i++) {
        if (alpha[i - 1] >= mask)
            alpha[i] = alpha[8] ^ ((alpha[i - 1] ^ mask) << 1);
        else
            alpha[i] = alpha[i - 1] << 1;
        indexes[alpha[i]] = i;
    }
    indexes[0] = 255;
    alpha[255] = 0;

    gg[0] = alpha[B0];
    gg[1] = 1;
    for (int32_t i = 2; i <= E; i++) {
        gg[i] = 1;
        for (int32_t j = i - 1; j > 0; j--) {
            if (gg[j] != 0)
                gg[j] = gg[j - 1] ^ alpha[modnn((indexes[gg[j]]) + B0 + i - 1)];
            else
                gg[j] = gg[j - 1];

        }
        gg[0] = alpha[modnn((indexes[gg[0]]) + B0 + i - 1)];
    }

    for (int32_t i = 0; i <= E; i++)
        gg[i] = indexes[gg[i]];
}

void encode_rs(uint8_t data[], uint8_t bb[])
{
    memset(bb, 0, E * sizeof(uint8_t));

    for (int32_t i = 255 - E - 1; i >= 0; i--) {
        int32_t feedback = indexes[data[i] ^ bb[E - 1]];
        if (feedback != 255) {
            for (int32_t j = E - 1; j > 0; j--) {
                if (gg[j] != 255)
                    bb[j] = bb[j - 1] ^ (uint8_t) alpha[modnn(gg[j] + feedback)];
                else
                    bb[j] = bb[j - 1];
            }
            bb[0] = (uint8_t) alpha[modnn(gg[0] + feedback)];
        }
        else {
            for (int32_t j = E - 1; j > 0; j--)
                bb[j] = bb[j - 1];
            bb[0] = 0;
        }
    }
}

void encode_bch(int32_t al, int32_t dl, int8_t *d, int8_t *p)
{
    const int8_t *gp;
    int8_t pp[13];
    int32_t el = al - dl;

    if (al == 15)
        gp = gp10;
    else
        gp = gp12;

    for (int32_t i = 0; i < el + 1; i++)
        pp[i] = i < dl ? d[i] : 0;

    for (int32_t i = 0; i < dl; i++) {
        if (pp[0] == 0) {
            for (int32_t j = 1; j <= el; j++)
                pp[j - 1] = pp[j];
            pp[el] = 0;
        }
        else
            for (int32_t j = 1; j <= el; j++)
                pp[j - 1] = pp[j] == gp[j] ? 0 : 1;
    }

    for (int32_t i = 0; i < el; i++)
        p[i] = pp[i];
}
