﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include "qre.h"
#include <nn/nn_Assert.h>

namespace devmenu {

#if defined( NN_DEVMENULOTCHECK )
/**
 * @brief QRコード生成
 *
 * @param[out] pOutRawImageInfo QRコードの生画像データ、情報
 * @param[out] pOutRawImageSize QRコードの生画像データのサイズ
 * @param[in] pHash             QRコードに埋め込む情報
 * @param[in] hashSize          QRコードに埋め込む情報のサイズ
 */
void CreateQrCode( mw::qre::ImageInfo* pOutRawImageInfo, uint32_t* pOutRawImageSize, uint8_t* pHash, uint32_t hashSize ) NN_NOEXCEPT;

#endif // defined( NN_DEVMENULOTCHECK )

} // ~namespace devmenu
