﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <functional>

#include <nn/time.h>

#include "../Common/DevMenu_CommonScene.h"
#include "../Common/DevMenu_CommonScrollBox.h"
#include "../DevMenu_Config.h"
#include "../DevMenu_Common.h"

namespace devmenu { namespace devicesettings { namespace tzselect {

class TimeZoneSelectionButton
    : public Button
{
public:
    TimeZoneSelectionButton(
        const char* string,
        const std::function< void() >& callback,
        const glv::Rect& rect, glv::Place::t anchor = glv::Place::TL ) NN_NOEXCEPT
        : Button( string, callback, rect, glv::Label::Spec( glv::Place::CC, 0.0f, 0.0f, CommonValue::InitialFontSize ) )
    {
    }
};

class TimeZoneSelectorScene : public Scene
{
public:

    TimeZoneSelectorScene( Page* pPage, const glv::Rect& rect, const std::function< void() >& closeCallback ) NN_NOEXCEPT;

    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE
    {
        m_ScrollableContainer.ScrollToTop();
    }

private:
    ScrollableBoxView m_ScrollableContainer;
    Button            m_BackButton;
};

}}} // ~namespace devmenu::tzselect, ~namespace devmenu
