﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include "../Common/DevMenu_CommonDropDown.h"
#include "DevMenu_DeviceSettingsCommon.h"

namespace devmenu { namespace devicesettings {

/**************************************
 * class SleepModeSetting
 **************************************/
class SleepModeSetting : public glv::Table
{
public:
    explicit SleepModeSetting( glv::space_t width ) NN_NOEXCEPT;

    void Refresh() NN_NOEXCEPT;

    void SetFocusTransitionPath( FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView ) NN_NOEXCEPT;

    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;

    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

private:
    void GetSettingsValue( void* pOutValue ) NN_NOEXCEPT;

    typedef std::pair< const bool, const char* > valuePair;

    void RegisterDropDownItems( void* pOutValues, DropDownBase* pDropDown ) NN_NOEXCEPT;

    void SetSettingsValue( bool selected, bool current ) NN_NOEXCEPT;

    DropDownComparableKeyValue< bool >* m_pDropDown;

    static const char* SettingName;
    static const char* KeyName;

    static const glv::WideString SleepHeader;
};

/**************************************
 * class IdleTimeDetectionDropDown
 **************************************/

class IdleTimeDetectionSetting : public glv::Table
{
public:
    explicit IdleTimeDetectionSetting( glv::space_t width ) NN_NOEXCEPT;

    void Refresh() NN_NOEXCEPT;

    void SetFocusTransitionPath( FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView ) NN_NOEXCEPT;

    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;

    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

private:
    void GetSettingsValue( void* pOutValue ) NN_NOEXCEPT;

    typedef std::pair< const bool, const char* > valuePair;

    void RegisterDropDownItems( void* pOutValues, DropDownBase* pDropDown ) NN_NOEXCEPT;

    void SetSettingsValue( bool selected, bool current ) NN_NOEXCEPT;

    DropDownComparableKeyValue< bool >* m_pDropDown;

    static const char* SettingName;
    static const char* KeyName;
};

/**************************************
 * class SleepSettings
 **************************************/

class SleepSettings: public SubsectionWithFocusUtility
{
public:
    SleepSettings( Page* pPage, glv::space_t width ) NN_NOEXCEPT;

    virtual void SetFocusTransitionPath( FocusManager* pFocusManager, glv::View* pPreviousFocusItem, glv::View* pNextFocusItem ) const NN_NOEXCEPT final NN_OVERRIDE;
    virtual glv::View* GetFirstFocusTargetView() const NN_NOEXCEPT final NN_OVERRIDE;
    virtual glv::View* GetLastFocusTargetView() const NN_NOEXCEPT final NN_OVERRIDE;

    virtual void OnLoopBeforeSceneRenderer() NN_NOEXCEPT final NN_OVERRIDE;
    virtual void OnLoopAfterSceneRenderer() NN_NOEXCEPT final NN_OVERRIDE;
    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;

private:
    SleepModeSetting*            m_pSleepMode;
    IdleTimeDetectionSetting*    m_pIdleTimeDetection;
};

}} // ~namespace devmenu::devicesettings, ~namespace devmenu
