﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_ApiPrivate.h>

#include "Accounts/DevMenu_AccountsConfig.h"
#include "Accounts/DevMenu_AccountsSdkHelper.h"
#include "DevMenu_ShopUserSelector.h"

namespace devmenu { namespace shop {

UserAccountSelector::UserAccountSelector(
    std::function< void( int ) > callback,
    const char* headerText ) NN_NOEXCEPT
    : ModalView( glv::Rect( 720.f, 480.f ) )
    , m_Placer( *this, glv::Direction::S, glv::Place::TC, width() / 2.0, .0f, 12.0f )
    , m_Message( headerText, glv::Label::Spec( glv::Place::TL, 0, 0, CommonValue::InitialFontSize ) )
    , m_Invalid( "[No valid users]", glv::Label::Spec( glv::Place::TL, 0, 0, accounts::Default::FontSizeSmall ) )
    , m_Cancel(  "Cancel", [&] { this->ExitModal(); }, glv::Rect( 240.f, 36.f ), glv::Place::TL )
{
    for ( int i = 0; i < nn::account::UserCountMax; ++i )
    {
        m_Buttons[i] = nullptr;
    }

    m_Placer << m_Message;

    // ユーザーリストの生成
    auto isSelectableUserAccountExisting = false;
    nn::account::Uid userIds[ nn::account::UserCountMax ];
    int count;
    nn::account::ListAllUsers( &count, userIds, sizeof( userIds ) / sizeof( userIds[ 0 ] ) );
    for ( int i = 0; i < count; ++i )
    {
        const auto& uid = userIds[ i ];
        NN_SDK_ASSERT( uid );

        if ( accounts::GetNetworkServiceAccountId( uid ) )
        {
            isSelectableUserAccountExisting = true;
            devmenu::accounts::UserButton* pButton = nullptr;
            pButton = new devmenu::accounts::UserButton( uid, [ this, callback, i ] { this->ExitModal(); callback( i ); }, glv::Rect( 640.f, 36.f) );
            NN_SDK_ASSERT( pButton != nullptr );
            m_Buttons[ i ] = pButton;

            m_Placer << pButton;
        }
    }

    // 有効なユーザーアカウントが存在しない場合のみ表示
    if ( !isSelectableUserAccountExisting )
    {
        m_Placer << m_Invalid;
    }

    m_Placer << m_Cancel;
}

UserAccountSelector::~UserAccountSelector() NN_NOEXCEPT
{
    for ( auto* p : m_Buttons )
    {
        if ( nullptr != p )
        {
            delete p;
        }
    }
}

}} // ~namespace devmenu::shop, ~namespace devmenu
