﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace devmenu {

// ToDo : 多少は体系立てて整理する

NN_DEFINE_ERROR_RANGE_RESULT(
    ResultApplicationError, 500, 1, 2 );
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultNotFound, 500, 2, 3 );
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultAccountNotFound, 500, 3, 4 );
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultApplicationNotLaunchable, 500, 4, 5 );
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultCmacError, 500, 5, 6 );                           // CustomerSupportTool用
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultSizeOverError, 500, 6, 7 );                       // CustomerSupportTool用
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultApplicationAndPatchTypeNotMatched, 500, 7, 8 );
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultNoLaunchRightsOnServer, 500, 51, 52 );            // 使用できる権利が無い
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultSystemUpdateRequiredToCheckLaunchRights, 500, 52, 53 ); // 権利の取得には本体更新が必要
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultAssignableRightsLimitExceeded, 500, 53, 54 );     // 権利を付与可能な上限数に達しているため使用する権利がない
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultHasDeviceLinkedRightsOnlyContent, 500, 54, 55 );  // 機器認証された本体でしか使用する権利がない
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultNotReleasedContent, 500, 55, 56 );                // 配信前のコンテンツのため使用する権利がない
NN_DEFINE_ERROR_RANGE_RESULT(
    ResultApplicationSuspendedByRightsError, 500, 56, 57 ); // 権利が十分でないためアプリケーションが中断した

} // ~namespace devmenu
