﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <functional>

#include "DevMenu_Common.h"

namespace nn { namespace arp {
    struct ApplicationLaunchProperty;
}}

namespace devmenu {

struct AbstructEventHandlers;
struct Icon;
struct IconCodePoint;

class FooterButton
    : public Button
{
public:
    FooterButton( const char* text, const std::function< void() >& callback, const glv::WideCharacterType* iconCodePoint, const glv::Rect& rect ) NN_NOEXCEPT;

private:
    Table      m_Table;
    IconLabel  m_Icon;
};

class FooterControls
    : public glv::View
{
public:
    FooterControls( const AbstructEventHandlers& handlers, const glv::Rect& rect = glv::Rect( 200.0f, 200.0f ) ) NN_NOEXCEPT;
    void UpdateApplicationInfo() NN_NOEXCEPT;
    void InvokeCloseApplication() NN_NOEXCEPT;
    void InvokeShowAppliactionDetailInfo() NN_NOEXCEPT;

private:

    // 実行中のアプリケーション管理
    class RunningApplicationController
        : public glv::View
    {
    public:
        RunningApplicationController( const AbstructEventHandlers& handlers, const glv::Rect& rect ) NN_NOEXCEPT;
        void UpdateApplicationInfo() NN_NOEXCEPT;

        /**
         * @brief       アプリケーション情報ボタンがクリックされた際に呼ばれます。
         */
        void OnAppliactionInfoClicked() NN_NOEXCEPT;

        /**
         * @brief       アプリケーション終了ボタンがクリックされた際に呼ばれます。
         */
        void OnCloseButtonClicked() NN_NOEXCEPT;

    private:
        // ToDo: ボタン追加時に再調整する
        static constexpr glv::space_t SpacerWidth = 280.0f;

    private:
        /**
         * @brief       アプリケーション再開ボタンがクリックされた際に呼ばれます。
         */
        void OnResumeButtonClicked() NN_NOEXCEPT;

        /**
         * @brief       実行中のアプリケーション情報を表示します。
         */
        void ShowApplicationInfo() NN_NOEXCEPT;

        /**
         * @brief       実行中のアプリケーション情報を非表示にします。
         */
        void HideApplicationInfo() NN_NOEXCEPT;

    private:
        const AbstructEventHandlers&  m_Handlers;
        glv::Placer m_Placer;

        // 実行中のアプリケーション情報
        class InfoView
            : public glv::Button
        {
        public:
            InfoView( const std::function< void() >& callback, const glv::Rect& rect ) NN_NOEXCEPT;
            void Update( bool isApplicationLaunchedJustBefore, const std::string& str ) NN_NOEXCEPT;

        private:
            void SetApplicationIcon() NN_NOEXCEPT;

        private:
            glv::Table    m_Table;             //!< 実行中のアプリケーション情報の配置テーブル
            glv::Label    m_Caption;           //!< アプリケーション実行中を示すラベル
            Icon          m_ApplicationIcon;   //!< 実行中のアプリケーションアイコン
            glv::Label    m_Storage;           //!< 実行中のアプリが存在するストレージ情報

            const std::function< void() > m_Callback;
        } m_InfoView;

        FooterButton  m_ResumeButton;   //!< アプリケーション再開ボタン
        FooterButton  m_CloseButton;    //!< アプリケーション終了ボタン
        Spacer        m_Spacer;         //!< 表示位置調整用スペース

        bool    m_IsShowing;   //!< アプリケーション情報の表示状態(操作ボタン含む)
        nn::arp::ApplicationLaunchProperty m_ApplicationLaunchProperty; // !< 実行中のアプリケーション起動プロパティ
    } m_ApplicationInfo;
};

} // ~namespace devmenu
