﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

namespace devmenu { namespace debugsettings {

    class FocusInfo
    {
    public:
        inline const glv::View* GetFirstFocusTargetView() const NN_NOEXCEPT
        {
            NN_ASSERT_NOT_NULL( m_pFirstFocusTargetView );
            return m_pFirstFocusTargetView;
        }

        inline const glv::View* GetLastFocusTargetView() const NN_NOEXCEPT
        {
            NN_ASSERT_NOT_NULL( m_pLastFocusTargetView );
            return m_pLastFocusTargetView;
        }

        inline bool IsFirstFocusedViewValid() const NN_NOEXCEPT
        {
            return nullptr != m_pFirstFocusTargetView;
        }

        inline bool IsLastFocusedViewValid() const NN_NOEXCEPT
        {
            return nullptr != m_pLastFocusTargetView;
        }

    protected:
        FocusInfo() NN_NOEXCEPT
            : m_pFirstFocusTargetView( nullptr )
            , m_pLastFocusTargetView( nullptr )
        {
        }

        inline void SetFirstFocusTargetView( const glv::View* const pView ) NN_NOEXCEPT
        {
            m_pFirstFocusTargetView = pView;
        }

        inline void SetLastFocusTargetView( const glv::View* const pView ) NN_NOEXCEPT
        {
            m_pLastFocusTargetView = pView;
        }

    private:
        const glv::View* m_pFirstFocusTargetView;
        const glv::View* m_pLastFocusTargetView;
    };

    class SettingsItemTableView : public glv::Table, public FocusInfo
    {
    protected:
        SettingsItemTableView(
            const char* arrangementStr = "<", glv::space_t paddingX = 3.0f, glv::space_t paddingY = 3.0f,
            const glv::Rect& rect = ( ( glv::Rect )( 0.0f ) ) ) NN_NOEXCEPT
            : glv::Table( arrangementStr, paddingX, paddingY, rect )
        {
        }
    };

}} // ~namespace devmenu::debugsettings, ~namespace devmenu
