﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>

/**
 * @brief       日時のユーティリティです。内部で nn::time ライブラリを使用します。
 */
namespace devmenu {

/**
 * @brief 日時を扱う構造体です。
 */
struct DateTime
{
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
};

/**
 * @brief       西暦1970年1月1日0時0分0秒 からの経過秒数を日時表現へ変換します。
 *
 * @param[out]  outDateTime         日時が入るアドレスを指定してください
 */
void FromPosixTime(
    DateTime& outDateTime,
    int64_t inPosixSecond) NN_NOEXCEPT;

/**
 * @brief       デバイス時計を表す現在時刻を 西暦1970年1月1日0時0分0秒 からの経過秒数で取得します。
 *
 * @return      デバイス時計を表す現在時刻の POSIX 時間を秒で返します。
 *
 * @details     ::nn::time::StandardUserSystemClock::GetCurrentTime( nn::time::PosixTime* )経由で取得可能なデバイスクロックに基づいた経過秒数を返します。
 */
int64_t GetPosixTime() NN_NOEXCEPT;

} // ~namespace devmenu
