﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv_core.h>
#include <glv_textview.h>

#include <nn/fs/fs_SystemSaveData.h>
#include <nn/nn_Log.h>

namespace devmenu {

//#define DEVMENU_ENABLE_LOG_DEBUG

#if defined( NN_DEVMENU_ENABLE_SYSTEM_APPLET )
    //#define DEVMENU_ENABLE_LOG_AE
    #define DEVMENU_ENABLE_NOTIFICATION
    #define DEVMENU_ENABLE_SLEEP_START
    #define DEVMENU_ENABLE_SLEEP_HANDLING
#else
    //#define DEVMENU_ENABLE_LOG_AE
    //#define DEVMENU_ENABLE_NOTIFICATION
#endif // defined( NN_DEVMENU_ENABLE_SYSTEM_APPLET )

#if defined( NN_SDK_BUILD_DEBUG ) || defined( NN_SDK_BUILD_DEVELOP )
#define DEVMENU_LOG(...) NN_LOG( "[DevMenu] " __VA_ARGS__ )
#else
#define DEVMENU_LOG(...)    static_cast<void>(0)
#endif

#if defined( DEVMENU_ENABLE_LOG_AE )
#define DEVMENU_LOG_AE DEVMENU_LOG
#else
#define DEVMENU_LOG_AE(...)    static_cast<void>(0)
#endif // defined( DEVMENU_ENABLE_LOG_AE )

#if defined ( DEVMENU_ENABLE_LOG_DEBUG )
#define DEVMENU_LOG_DEBUG DEVMENU_LOG
#else
#define DEVMENU_LOG_DEBUG(...)    static_cast<void>(0)
#endif // defined( DEVMENU_ENABLE_LOG_DEBUG )

// CI 上での統計情報収集用のログ出力マクロ
#if defined( NN_SDK_BUILD_DEBUG ) || defined( NN_SDK_BUILD_DEVELOP )
#if defined( NN_BUILD_CONFIG_ADDRESS_SUPPORTS_64 )
#define DEVMENU_LOG_CI_PERFORMANCE_STATISTICS( key, value ) NN_LOG( "##teamcity[buildStatisticValue key='%s' value='%lld']\n", ( key ), ( value ) );
#else
#define DEVMENU_LOG_CI_PERFORMANCE_STATISTICS( key, value ) NN_LOG( "##teamcity[buildStatisticValue key='%s' value='%ld']\n", ( key ), ( value ) );
#endif // defined( NN_BUILD_CONFIG_ADDRESS_SUPPORTS_64 )
#else
#define DEVMENU_LOG_CI_PERFORMANCE_STATISTICS( key, value )    static_cast<void>(0)
#endif

/**
 * @brief       DevMenu ページの識別子です。
 */
enum DevMenuPageId
{
#if !defined( NN_CUSTOMERSUPPORTTOOL )
    DevMenuPageId_Application       = 0x0000,       //!< アプリケーション一覧
#endif
    DevMenuPageId_SaveData          = 0x0010,       //!< セーブデータ一覧
#if !defined( NN_DEVMENULOTCHECK ) && !defined( NN_CUSTOMERSUPPORTTOOL )
    DevMenuPageId_Controller        = 0x0020,       //!< コントローラー
    DevMenuPageId_Accounts          = 0x0030,       //!< アカウント
    DevMenuPageId_Device            = 0x0040,       //!< 本体設定
    DevMenuPageId_NetworkConnection = 0x0050,       //!< ネットワーク接続
    DevMenuPageId_Prepo             = 0x0060,       //!< プレイレポート
    DevMenuPageId_Sound             = 0x0070,       //!< サウンド設定
    DevMenuPageId_TimeTest          = 0x0080,       //!< 時計テスト機能
    DevMenuPageId_Debug             = 0x0090,       //!< デバッグ設定
    DevMenuPageId_Error             = 0x00a0,       //!< エラー一覧
#endif

#if !defined( NN_DEVMENULOTCHECK ) && !defined( NN_DEVMENULOTCHECK_DOWNLOADER ) && !defined( NN_CUSTOMERSUPPORTTOOL )
    DevMenuPageId_Shop              = 0x00b0,       //!< ショップ
#endif

#if defined( NN_DEVMENUSYSTEM )
    DevMenuPageId_SystemProgram     = 0x0100,       //!< システムプログラム
    DevMenuPageId_SystemUpdate      = 0x0110,       //!< 本体更新
    DevMenuPageId_Download          = 0x0120,       //!< コンテンツダウンロード
    DevMenuPageId_FileSystem        = 0x0130,       //!< ファイルシステム
    DevMenuPageId_Command           = 0x0140,       //!< コマンド
    DevMenuPageId_Ticket            = 0x0150,       //!< チケット
    DevMenuPageId_Lcs               = 0x0170,       //!< ローカルコンテンツ配信
    DevMenuPageId_CroudBackup       = 0x0180,       //!< クラウドバックアップ
#endif

#if defined( NN_CUSTOMERSUPPORTTOOL )
    DevMenuPageId_Accounts          = 0x0030,       //!< アカウント
    DevMenuPageId_CustomerSupport   = 0x0160,       //!< カスタマーサポート
#endif

#if !defined( NN_CUSTOMERSUPPORTTOOL )
    DevMenuPageId_Firmware          = 0xFFFF,       //!< ファームウェア情報
#endif

    DevMenuPageId_Sample            = 0x00100000,   //!< サンプル
};

/**
 * @brief       DevMenu 既定の定数値です。
 */

struct SaveDataMeta
{
    nn::fs::SystemSaveDataId  id;
    int64_t                   dataSize;
    int64_t                   journalSize;
    std::string               mountName;
};

struct CommonValue
{
    static const SaveDataMeta     OwnSaveDataMeta;  //!< セーブデータメタ
    static const float            InitialFontSize;  //!< 既定のフォントサイズ
    static const glv::Rect        DefaultPageRect;  //!< 既定のページサイズ
    static const glv::Label::Spec DefaultLabelSpec; //!< 既定のラベルスペック
};

} // ~namespace devmenu
