﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>

#include "../DevMenu_Config.h"

namespace devmenu {

/**
 * @brief デバッグモードが有効か否かを表す値を返します。
 *
 * @details Horizon OS 環境では実行環境が開発環境ならば true, 製品環境ならば false を返します。
 *          Horizon OS 環境以外では常に true を返します。
 *
 * @return デバッグモードが有効か否かを表す値です。
 */
bool IsDebugModeEnabled() NN_NOEXCEPT;

template< typename T >
bool GetFixedSizeFirmwareDebugSettingsItemValue( T* pOutValue, const char* name, const char* key, bool isAbortEnabled = true ) NN_NOEXCEPT
{
#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    const auto valueSize = sizeof( T );
    T value = {};
    const auto readSize = nn::settings::fwdbg::GetSettingsItemValue( &value, valueSize, name, key );

    if ( readSize != valueSize )
    {
        nn::settings::fwdbg::ResetSettingsItemValue( name, key );
        DEVMENU_LOG( "Reset \"%s.%s\" setting\n", name, key );
        const auto readSizeAfterReset = nn::settings::fwdbg::GetSettingsItemValue( &value, valueSize, name, key );

        if ( readSizeAfterReset != valueSize )
        {
            if ( isAbortEnabled )
            {
                NN_ABORT( "Failed to read \"%s.%s\" setting\n", name, key );
            }
            else
            {
                NN_SDK_ASSERT( "Failed to read \"%s.%s\" setting\n", name, key );
            }
            return false;
        }
    }
    DEVMENU_LOG_DEBUG( "Succeed to read \"%s.%s\" setting\n", name, key );
    *pOutValue = value;

#else
    NN_UNUSED( pOutValue );
    NN_UNUSED( name );
    NN_UNUSED( key );
    NN_UNUSED( isAbortEnabled );
#endif
    return true;
}

bool GetVariableSizeFirmwareDebugSettingsItemValue( void* outBuf, size_t bufSize, const char* name, const char* key, bool isAbortEnabled = true ) NN_NOEXCEPT;

template< typename T >
void SetFixedSizeFirmwareDebugSettingsItemValue( const char* name, const char* key, const T& value ) NN_NOEXCEPT
{
#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    nn::settings::fwdbg::SetSettingsItemValue( name, key, &value, sizeof( T ) );
#else
    NN_UNUSED( name );
    NN_UNUSED( key );
    NN_UNUSED( value );
#endif
}

void SetVariableSizeFirmwareDebugSettingsItemValue( const char* name, const char* key , const void* pValue, size_t valueSize ) NN_NOEXCEPT;

} // ~namespace devmenu
