﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenu_CommonDropDown.h"

namespace devmenu {

/************************************
 * class DropDownBase, WideDropDown
 ************************************/

bool DropDownBase::onEvent( glv::Event::t event, glv::GLV& glvRoot ) NN_NOEXCEPT
{
    switch( event )
    {
    case glv::Event::DebugPadDown:
        {
            const auto& debugPad = glvRoot.getDebugPadEvent();
            if ( debugPad.IsButtonDown< glv::DebugPadEventType::ButtonOk >() && !IsShowingList() )
            {
                showList();
                return false;
            }
        }
        break;
    case glv::Event::BasicPadDown:
        {
            const auto& basicPad = glvRoot.getBasicPadEvent();
            if ( basicPad.IsButtonDown< glv::BasicPadEventType::Button::Ok >() && !IsShowingList() )
            {
                showList();
                return false;
            }
        }
        break;
    default: break;
    }

    return glv::DropDown::onEvent( event, glvRoot );
}

bool WideDropDown::onEvent( glv::Event::t event, glv::GLV& glvRoot ) NN_NOEXCEPT
{
    switch( event )
    {
    case glv::Event::DebugPadDown:
        {
            const auto& debugPad = glvRoot.getDebugPadEvent();
            if ( debugPad.IsButtonDown< glv::DebugPadEventType::ButtonOk >() && !IsShowingList() )
            {
                showList();
                return false;
            }
        }
        break;
    case glv::Event::BasicPadDown:
        {
            const auto& basicPad = glvRoot.getBasicPadEvent();
            if ( basicPad.IsButtonDown< glv::BasicPadEventType::Button::Ok >() && !IsShowingList() )
            {
                showList();
                return false;
            }
        }
        break;
    default:break;
    }

    return glv::WideDropDown::onEvent( event, glvRoot );
}

/*******************************************
 * class DropDownStringKeyValueBase
 *******************************************/

DropDownStringKeyValueBase::DropDownStringKeyValueBase( const glv::Rect& rect, float textSize, const std::function< void( const std::string& , const std::string& ) >& callback ) NN_NOEXCEPT
    : DropDownBase( rect, textSize )
    , m_Callback( callback )
{
    mItemList.font().size( textSize * 1.0f );
}

void DropDownStringKeyValueBase::Refresh() NN_NOEXCEPT
{
    SetDropDownValue( GetSettingsValue() );
}

const std::string& DropDownStringKeyValueBase::GetDropDownItemString( const std::string& value ) NN_NOEXCEPT
{
    NN_ASSERT( 0 < m_Values.size() );

    for ( const auto& iter: m_Values )
    {
        if ( value == iter.first )
        {
            return iter.second;
        }
    }
    NN_ABORT( "Must not come here\n" );
}

void DropDownStringKeyValueBase::SetDropDownValue( const std::string& value ) NN_NOEXCEPT
{
    for ( const auto& iter: m_Values )
    {
        if ( value == iter.first )
        {
            setValue( iter.second );
            return;
        }
    }
    NN_ABORT( "Must not come here\n" );
}

void DropDownStringKeyValueBase::UpdateSettingsValue() NN_NOEXCEPT
{
    auto& selectedValue = m_Values.at( mSelectedItem ).first;
    auto currentValue = GetSettingsValue();
    if ( selectedValue != currentValue )
    {
        m_Callback( selectedValue, currentValue );
    }
}

} // ~namespace devmenu
