﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DevMenu_CloudBackupCommons.h"


namespace devmenu { namespace cloudbackup {

/**
* ON/OFF等を切り替えるボタン
* TODO:削除予定
*/
class ToggleButton : public Button
{
public:
    ToggleButton(const char* onCaption, const char* offCaption, bool isOn,
        std::function< void(bool isOn) > callback, const glv::Rect& rect, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT
        : Button(isOn == true ? onCaption : offCaption, [&] { OnClick(); }, rect, anchor)
        , m_IsOn(isOn)
        , m_pOnCaption(onCaption)
        , m_pOffCaption(offCaption)
        , m_CallBack(callback)
    {
        // NOOP
    }

    /**
    * On/Offフラグ取得
    */
    bool IsOn() const NN_NOEXCEPT
    {
        return m_IsOn;
    }

    /**
    * 状態設定
    */
    void SetStatus(bool isOn, bool isCallBack = false) NN_NOEXCEPT
    {
        m_IsOn = isOn;
        UpdateLabelText(m_IsOn == true ? m_pOnCaption : m_pOffCaption);

        if (isCallBack == true && m_CallBack != nullptr)
        {
            m_CallBack(m_IsOn);
        }
    }

private :

    /**
    * クリックイベント
    */
    void OnClick() NN_NOEXCEPT
    {
        SetStatus(!m_IsOn, true);
    }

    // ON/OFFフラグ※Button View自体のではない
    bool m_IsOn;

    // On時文字列
    const char* m_pOnCaption;

    // Off時文字列
    const char* m_pOffCaption;

    // クリックコールバック
    std::function< void(bool isOn) > m_CallBack;
};

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
