﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include "../Common/DevMenu_CommonScrollBox.h"

#include "DevMenu_CloudBackupCommons.h"
#include "DevMenu_ToggleButton.h"
#include "DevMenu_AccountView.h"


namespace devmenu { namespace cloudbackup {

/**
* 自律処理の制御
* TODO:ファイルを分ける
*/
class TaskControl : public glv::Table, public FocusSettingInterface
{
public:
    /**
    * コンストラクタ
    */
    explicit TaskControl(const glv::Rect& rect) NN_NOEXCEPT;

    /**
    * 更新
    */
    void Refresh() NN_NOEXCEPT;

    /**
    * クリア
    */
    void Clear() NN_NOEXCEPT;

    /**
    * 最初にFocusを当てるViewを取得
    */
    virtual glv::View* GetFirstFocusTargetView() NN_NOEXCEPT NN_OVERRIDE;

    /**
    * 最後にFocusを当てるViewを取得
    */
    virtual glv::View* GetLastFocusTargetView() NN_NOEXCEPT NN_OVERRIDE;

    /**
    * フォーカス設定
    */
    virtual void SetFocusTransitionPath(FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView) NN_NOEXCEPT NN_OVERRIDE;

private:
    // 幅確保用
    Spacer m_Spacer;

    //
    devmenu::CheckBoxButton m_CheckBoxToStopAutonomousTask;

    //
    devmenu::CheckBoxButton m_CheckBoxToStopTransferTask;
};

/**
* デバイス情報
*/
class DeviceInfo : public glv::Table, public FocusSettingInterface
{
public:
    /**
    * コンストラクタ
    */
    explicit DeviceInfo(const glv::Rect& rect) NN_NOEXCEPT;

    /**
    * タスクリスト遷移ボタン押下コールバック設定
    */
    void SetClickCallbackToShowTransferTaskList(const std::function<void()>& callback) NN_NOEXCEPT;

    /**
    * エラーリスト遷移ボタン押下コールバック設定
    */
    void SetClickCallbackToShowErrorList(const std::function<void()>& callback) NN_NOEXCEPT;

    /**
    * 更新
    */
    void Refresh() NN_NOEXCEPT;

    /**
    * クリア
    */
    void Clear() NN_NOEXCEPT;

    /**
    * 最初にFocusを当てるViewを取得
    */
    virtual glv::View* GetFirstFocusTargetView() NN_NOEXCEPT NN_OVERRIDE;

    /**
    * 最後にFocusを当てるViewを取得
    */
    virtual glv::View* GetLastFocusTargetView() NN_NOEXCEPT NN_OVERRIDE;

    /**
    * フォーカス設定
    */
    virtual void SetFocusTransitionPath(FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView) NN_NOEXCEPT NN_OVERRIDE;

private:
    // 幅確保用
    Spacer m_Spacer;

    // タスクリスト表示ラベル
    glv::Label m_LabelShowTransferTaskList;

    // タスクリスト表示ボタン
    Button m_ButtonShowTransferTaskList;

    // エラーリスト表示ラベル
    glv::Label m_LabelShowErrorList;

    // エラーリスト表示ボタン
    Button m_ButtonShowErrorList;
};

/**
* Cloud Backup Scene
* TODO:アカウント更新等のレシーバーを後でつける
*/
class CloudBackupScene : public Scene
{
public:
    /**
    * コンストラクタ
    */
    CloudBackupScene(ParentPageInterface* pParentPage, const glv::Rect& rect) NN_NOEXCEPT;

    /**
    * クリア
    */
    void Clear() NN_NOEXCEPT;

    /**
    * リフレッシュ
    */
    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;

    /**
    * 描画前コールバック
    */
    virtual void OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT NN_OVERRIDE;

    /**
    * アクティブ処理
    */
    virtual void OnActivatePage() NN_NOEXCEPT NN_OVERRIDE;

    /**
    * シーンに入る際の遷移イベント
    */
    virtual void OnEnterScene() NN_NOEXCEPT NN_OVERRIDE;

private:
    /**
    * アカウントリストの更新
    */
    void RefreshAccountList(ScrollableBoxView* pScrollBox) NN_NOEXCEPT;

    /**
    * アカウントリストの除去
    */
    void RemoveAccountList() NN_NOEXCEPT;

    /**
    * フォーカス設定
    */
    void RefreshFocusSetting() NN_NOEXCEPT;

private:
    // Pageの処理を呼ぶためのInterface
    ParentPageInterface* m_pParentPage;

    // フォーカス管理
    ScrollFocusManager m_FocusManager;

    // 全体のTable
    glv::Table m_LayoutTable;

    // 自律処理の制御ヘッダ
    glv::View* m_pTaskControlHeader;

    // 自律処理の制御
    TaskControl m_TaskControl;

    // デバイス情報ヘッダ
    glv::View* m_pDeviceInfoHeader;

    // デバイス情報
    DeviceInfo m_DeviceInfo;

    // スクロールコンテナ
    ScrollableBoxView m_ScrollContainer;

    // アカウントヘッダ
    glv::View* m_pAccountInfoListHeader;

    // アカウントリストコンテナ
    AccountInfoList m_AccountInfoList;

    // アカウント無しラベル
    glv::Label m_LabelNoItemAccount;
};

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
