﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../Common/DevMenu_Buffer.h"
#include "../Common/DevMenu_CommonScrollBox.h"
#include "../Common/DevMenu_CommonFocusManager.h"

#include "../DevMenu_Common.h"
#include "../DevMenu_RootSurface.h"
#include "../Accounts/DevMenu_AccountsSdkHelper.h"


namespace devmenu { namespace cloudbackup {

static const glv::Label::Spec DefaultLabelSpec(glv::Place::TL, 5.0f, 0.0f, CommonValue::InitialFontSize);
static const glv::Label::Spec SmallLabelSpec(glv::Place::BL, 0.0f, 0.0f, 16.0f);

static const glv::space_t DefaultCategoryHeaderHeight = 50.f;
static const glv::space_t DefaultButtonWidth = 320.f;
static const glv::space_t DefaultButtonHeight = 35.f;
static const glv::space_t DefaultRightPadding = 34.f;

/**
* シーンタイプ
*/
enum SceneType
{
    SceneType_CloudBackupRoot = 0,
    SceneType_TransferTaskList,
    SceneType_ErrorList,
    SceneType_AccountInfo,
    SceneType_ApplicationInfo,
};

/**
* SceneからPageの処理を呼ぶ為のインターフェース
*/
class ParentPageInterface
{
public:

    /**
    * シーン切り替え
    */
    virtual void SwitchScene(SceneType nextScene, bool isBack) NN_NOEXCEPT = 0;

    /**
    * RootSurfaceContextの取得
    */
    virtual RootSurfaceContext* GetParentPageRootSurfaceContext() const NN_NOEXCEPT = 0;

    /**
    * アカウント情報を開く
    */
    virtual void OpenAccountInfo(const nn::account::Uid& uid) NN_NOEXCEPT = 0;

    /**
    * コンストラクタ
    */
    ParentPageInterface() NN_NOEXCEPT
    {
        // NOOP
    };
};

/**
* フォーカス設定用インターフェース
*/
class FocusSettingInterface
{
public:
    /**
    * 最初にFocusを当てるViewを取得
    */
    virtual glv::View* GetFirstFocusTargetView() NN_NOEXCEPT = 0;

    /**
    * 最後にFocusを当てるViewを取得
    */
    virtual glv::View* GetLastFocusTargetView() NN_NOEXCEPT = 0;

    /**
    * フォーカス設定
    */
    virtual void SetFocusTransitionPath(FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView) NN_NOEXCEPT = 0;
};

/**
* スクロール連動FocusManager
*/
class ScrollFocusManager : public FocusManager
{
public:
    /**
    * コンストラクタ
    */
    explicit ScrollFocusManager(ScrollableBoxView* pScrollableBoxView = nullptr) NN_NOEXCEPT;

    /**
    * 連動させるScrollableBoxViewを設定
    */
    void SetParentScroll(ScrollableBoxView* pScrollableBoxView) NN_NOEXCEPT;

    /**
    * イベント処理
    */
    virtual bool onEvent(glv::View& view, glv::GLV& glvRoot) NN_NOEXCEPT NN_OVERRIDE;

private:
    /**
    * 連動させるScrollableBoxView
    */
    ScrollableBoxView* m_pParentScroll;
};

/**
* カテゴリのヘッダViewを作成する
*/
glv::Table* CreateCategoryHeader(const char* text, const glv::Label::Spec& spec, const glv::Rect& rect) NN_NOEXCEPT;

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
