﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../Common/DevMenu_CommonScrollBox.h"
#include "DevMenu_CloudBackupCommons.h"
#include "DevMenu_ToggleButton.h"


namespace devmenu { namespace cloudbackup {



/**
* Application Info Scene
*/
class ApplicationInfoScene : public Scene
{
public:
    /**
    * コンストラクタ
    */
    ApplicationInfoScene(ParentPageInterface* pParentPage, const glv::Rect& rect) NN_NOEXCEPT;

    /**
    * 更新
    */
    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;

    /**
    * クリア
    */
    void Clear() NN_NOEXCEPT;

    /**
    * 描画前コールバック
    */
    virtual void OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT NN_OVERRIDE;

    /**
    * シーンに入る際の遷移イベント
    */
    virtual void OnEnterScene() NN_NOEXCEPT NN_OVERRIDE;

    /**
    * アクティブ処理
    */
    virtual void OnActivatePage() NN_NOEXCEPT NN_OVERRIDE;

private:
    /**
    * セーブデータ情報ヘッダView
    */
    class SaveDataHeader : public glv::Table
    {
    public:
        /**
        * コンストラクタ
        */
        explicit SaveDataHeader(const glv::Rect& rect) NN_NOEXCEPT;

        /**
        * 更新
        * TODO:セーブデータ/アプリケーションのキーを受け取る予定
        */
        void Refresh() NN_NOEXCEPT;

        /**
        * クリア
        */
        void Clear() NN_NOEXCEPT;

    private:
        // 幅確保用
        Spacer m_Spacer;

        // 横インデント

        // アプリ名ラベル
        glv::Label m_LabelName;

        // アプリIDラベル
        glv::Label m_LabelId;

        // アプリバージョンラベル
        glv::Label m_LabelVersion;
    };

    /**
    * セーブデータ詳細情報View
    */
    class SaveDataDetailInfo : public glv::Table
    {
    public:
        /**
        * コンストラクタ
        */
        explicit SaveDataDetailInfo(const glv::Rect& rect) NN_NOEXCEPT;

        /**
        * 更新
        * TODO:セーブデータ/アプリケーションのキーを受け取る予定
        */
        void Refresh() NN_NOEXCEPT;

        /**
        * クリア
        */
        void Clear() NN_NOEXCEPT;

    private:
        // 幅確保用
        Spacer m_Spacer;

        // アプリアイコン
        ApplicationIcon m_ApplicationIcon;

        // 文字列ラベル
        glv::Label m_LabelApplicationInfo;// アプリに関する情報
        glv::Label m_LabelLocalSaveDataInfo;// セーブデータに関する情報
        glv::Label m_LabelBackupInfo;// バックアップに関する情報
    };

    /**
    * タスク操作View
    */
    class TaskControl : public glv::Table
    {
    public:
        /**
        * コンストラクタ
        */
        explicit TaskControl(const glv::Rect& rect) NN_NOEXCEPT;

        /**
        * 更新
        * TODO:セーブデータ/アプリケーションのキーを受け取る予定
        */
        void Refresh() NN_NOEXCEPT;

        /**
        * クリア
        */
        void Clear() NN_NOEXCEPT;

    private:
        // 幅確保用
        Spacer m_Spacer;

        // 自動UL設定
        CheckBoxButton m_CheckboxToAutoUploadEnabled;

        // タスク情報ラベル
        glv::Label m_LabelOpenTaskInfoModal;

        // タスクの情報ボタン
        Button m_ButtonOpenTaskInfoModal;

        // ULタスク登録ラベル
        glv::Label m_LabelRegisterUploadTask;

        // ULタスク登録ボタン
        Button m_ButtonRegisterUploadTask;

        // DLタスク作成ラベル
        glv::Label m_LabelRegisterDownloadTask;

        // DLタスク作成ボタン
        Button m_ButtonRegisterDownloadTask;

        // 系列情報の削除ラベル
        glv::Label m_LabelDeleteInfo;

        // 系列情報削除ボタン
        Button m_ButtonDeleteInfo;
    };

    /**
    * キャッシュ操作View
    */
    class CacheControl : public glv::Table
    {
    public:
        /**
        * コンストラクタ
        */
        explicit CacheControl(const glv::Rect& rect) NN_NOEXCEPT;

        /**
        * 更新
        * TODO:セーブデータ/アプリケーションのキーを受け取る予定
        */
        void Refresh() NN_NOEXCEPT;

        /**
        * クリア
        */
        void Clear() NN_NOEXCEPT;

    private:
        // 幅確保用
        Spacer m_Spacer;

        // サーバー情報キャッシュラベル
        glv::Label m_LabelDataInfoCache;

        // サーバー情報キャッシュ更新ボタン
        Button m_ButtonUpdateDataInfoCache;

        // サーバー情報キャッシュ削除ボタン
        Button m_ButtonDeleteDataInfoCache;

        // サムネイルダウンロードラベル
        glv::Label m_LabelUpdateThumbnailCache;

        // サムネイルダウンロードボタン
        Button m_ButtonUpdateThumbnailCache;
    };

    /**
    * サーバー操作View
    */
    class ServerControl : public glv::Table
    {
    public:
        /**
        * コンストラクタ
        */
        explicit ServerControl(const glv::Rect& rect) NN_NOEXCEPT;

        /**
        * 更新
        * TODO:セーブデータ/アプリケーションのキーを受け取る予定
        */
        void Refresh() NN_NOEXCEPT;

        /**
        * クリア
        */
        void Clear() NN_NOEXCEPT;

    private:
        // 幅確保用
        Spacer m_Spacer;

        // バックアップデータ削除ラベル
        glv::Label m_LabelDeleteBackupData;

        // バックアップデータ削除ボタン
        Button m_ButtonDeleteBackupData;
    };

private:
    // ページの処理を呼ぶためのインターフェース
    ParentPageInterface* m_pParentPage;

    // 戻る
    Button* m_pButtonBack;

    // 全体のコンテナ
    glv::Table m_LayoutTable;

    // 共通のスクロールコンテナ
    ScrollableBoxView m_ScrollBoxView;

    // ヘッダ
    SaveDataHeader m_SaveDataHeader;

    // 詳細情報
    SaveDataDetailInfo m_SaveDataDetailInfo;

    // タスク操作ヘッダ
    glv::View* m_pTaskControlHeader;

    // タスク操作
    TaskControl m_TaskControl;

    // タスク操作ヘッダ
    glv::View* m_pCacheControlHeader;

    // キャッシュ操作
    CacheControl m_CacheControl;

    // サーバー操作ヘッダ
    glv::View* m_pServerControlHeader;

    // サーバー操作
    ServerControl m_ServerControl;

};

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
