﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenu_ApplicationInfoScene.h"


namespace devmenu { namespace cloudbackup {

/**************************************
class ApplicationInfoScene::SaveDataHeader
**************************************/
/**
* コンストラクタ
*/
ApplicationInfoScene::SaveDataHeader::SaveDataHeader(const glv::Rect& rect) NN_NOEXCEPT
    : glv::Table("<", 8.f, 12.f)
    , m_Spacer(rect.w - DefaultRightPadding, 1)
    , m_LabelName("",DefaultLabelSpec)
    , m_LabelId("", SmallLabelSpec)
    , m_LabelVersion("", SmallLabelSpec)
{
    this->disable(glv::Property::HitTest | glv::Property::Controllable);
    this->enable(glv::Property::DrawBack | glv::Property::DrawBorder);
}

/**
* 更新
* TODO:セーブデータ/アプリケーションのキーを受け取る予定
*/
void ApplicationInfoScene::SaveDataHeader::Refresh() NN_NOEXCEPT
{
    Clear();

    // TODO:アプリケーションの情報取得処理を追加すること。
    // TODO:ダミーテキスト
    m_LabelName.setValue("Application Name:Dummy Name");
    m_LabelId.setValue("Application ID:0xXXXXXXXXXXXXXXXX");
    m_LabelVersion.setValue("Version Number:0.0.0");

    *this
        << m_LabelName
        << m_Spacer
        << m_LabelId
        << m_LabelVersion;

    this->fit(false);
    this->arrange();
}

/**
* クリア
*/
void ApplicationInfoScene::SaveDataHeader::Clear() NN_NOEXCEPT
{
    m_LabelName.remove();
    m_Spacer.remove();
    m_LabelId.remove();
    m_LabelVersion.remove();
}

/**************************************
class ApplicationInfoScene::SaveDataHeader
**************************************/
/**
* コンストラクタ
*/
ApplicationInfoScene::SaveDataDetailInfo::SaveDataDetailInfo(const glv::Rect& rect) NN_NOEXCEPT
    : glv::Table("< < , | <, | < , < -", 0.f, 0.f)
    , m_Spacer(rect.w - DefaultRightPadding, 1)
    , m_ApplicationIcon(128, 128, 0.f, 0.f)
    , m_LabelApplicationInfo("", SmallLabelSpec)
    , m_LabelLocalSaveDataInfo("", SmallLabelSpec)
    , m_LabelBackupInfo("", SmallLabelSpec)
{
    this->disable(glv::Property::HitTest | glv::Property::Controllable);
    //////////////// TODO:配置が決まったら消す
    m_LabelApplicationInfo.enable(glv::Property::DrawBack | glv::Property::DrawBorder);
    m_LabelLocalSaveDataInfo.enable(glv::Property::DrawBack | glv::Property::DrawBorder);
    m_LabelBackupInfo.enable(glv::Property::DrawBack | glv::Property::DrawBorder);
    ////////////////
}

/**
* 更新
* TODO:セーブデータ/アプリケーションのキーを受け取る予定
*/
void ApplicationInfoScene::SaveDataDetailInfo::Refresh() NN_NOEXCEPT
{
    Clear();

    /**▼▼ ダミーデータ ▼▼************************************************************/
    /*------------------------------------------------*/
    // アイコン(仮)
    m_ApplicationIcon.ClearTexture();
    /*------------------------------------------------*/
    // TODO:アプリケーションの情報取得処理を追加すること。
    // TODO:ダミーテキスト
    // アプリに関する情報
    m_LabelApplicationInfo.setValue("Policy :Dummy\nAuto Upload: Dummy");

    // セーブデータに関する情報
    m_LabelLocalSaveDataInfo.setValue(
        "Existence: Dummy, TimeStamp: 1234/56/78 90:12:34\nVersion: 0.0.0, LastSi.id: Dummy, Auto Upload: possible/impossible?");

    // バックアップに関する情報
    m_LabelBackupInfo.setValue(
        "Existence: Dummy, TimeStamp: 1234/56/78 90:12:34\nVersion: 0.0.0, ServerSi.id: Dummy, Auto DownLoad: possible/impossible?");
    /**▲▲ ダミーデータ ▲▲************************************************************/

    *this
        << m_ApplicationIcon
        << m_LabelApplicationInfo
        << m_LabelLocalSaveDataInfo
        << m_LabelBackupInfo
        << m_Spacer;

    this->fit(false);
    this->arrange();
}

/**
* クリア
*/
void ApplicationInfoScene::SaveDataDetailInfo::Clear() NN_NOEXCEPT
{
    m_ApplicationIcon.remove();
    m_LabelApplicationInfo.remove();
    m_LabelLocalSaveDataInfo.remove();
    m_LabelBackupInfo.remove();
    m_Spacer.remove();
}


/**************************************
class ApplicationInfoScene::SaveDataHeader
**************************************/
/**
* コンストラクタ
*/
ApplicationInfoScene::TaskControl::TaskControl(const glv::Rect& rect) NN_NOEXCEPT
    : glv::Table("< - , < > , < > , < > , < > , < -", 0.f, 12.f)
    , m_Spacer(rect.w - DefaultRightPadding, 1.f)
    , m_CheckboxToAutoUploadEnabled("Auto Upload")
    , m_LabelOpenTaskInfoModal("Task Info", DefaultLabelSpec)
    , m_ButtonOpenTaskInfoModal("Open", nullptr, glv::Rect(DefaultButtonWidth, DefaultButtonHeight))
    , m_LabelRegisterUploadTask("Upload Task", DefaultLabelSpec)
    , m_ButtonRegisterUploadTask("Register", nullptr, glv::Rect(DefaultButtonWidth, DefaultButtonHeight))
    , m_LabelRegisterDownloadTask("Download Task", DefaultLabelSpec)
    , m_ButtonRegisterDownloadTask("Register", nullptr, glv::Rect(DefaultButtonWidth, DefaultButtonHeight))
    , m_LabelDeleteInfo("Delete Information", DefaultLabelSpec)
    , m_ButtonDeleteInfo("Start", nullptr, glv::Rect(DefaultButtonWidth, DefaultButtonHeight))
{
    // 自動UL設定
    m_CheckboxToAutoUploadEnabled.SetCallback(
        [](const glv::Notification& notification)->void
        {
            // TODO:後で処理を追加予定
        }
        , this);

    // タスクの情報
    m_ButtonOpenTaskInfoModal.SetCallback(
        [&]
        {
            // TODO:後で処理を追加する
        }
        );

    // ULタスクを登録
    m_ButtonRegisterUploadTask.SetCallback(
        [&]
        {
            // TODO:後で処理を追加する
        }
        );

    // DLタスクの作成
    m_ButtonRegisterDownloadTask.SetCallback(
        [&]
        {
            // TODO:後で処理を追加する
        }
        );
    // 系列情報の削除
    m_ButtonDeleteInfo.SetCallback(
        [&]
        {
            // TODO:後で処理を追加する
        }
        );
}

/**
* 更新
* TODO:セーブデータ/アプリケーションのキーを受け取る予定
*/
void ApplicationInfoScene::TaskControl::Refresh() NN_NOEXCEPT
{
    Clear();

    // TODO:値はAPIで取得予定
    m_CheckboxToAutoUploadEnabled.SetValue(false);

    // 設定
    *this
        << m_CheckboxToAutoUploadEnabled
        << m_LabelOpenTaskInfoModal
        << m_ButtonOpenTaskInfoModal
        << m_LabelRegisterUploadTask
        << m_ButtonRegisterUploadTask
        << m_LabelRegisterDownloadTask
        << m_ButtonRegisterDownloadTask
        << m_LabelDeleteInfo
        << m_ButtonDeleteInfo
        << m_Spacer;

    this->arrange();
}

/**
* クリア
*/
void ApplicationInfoScene::TaskControl::Clear() NN_NOEXCEPT
{
    // 一旦外す
    m_CheckboxToAutoUploadEnabled.remove();
    m_LabelOpenTaskInfoModal.remove();
    m_ButtonOpenTaskInfoModal.remove();
    m_LabelRegisterUploadTask.remove();
    m_ButtonRegisterUploadTask.remove();
    m_LabelRegisterDownloadTask.remove();
    m_ButtonRegisterDownloadTask.remove();
    m_LabelDeleteInfo.remove();
    m_ButtonDeleteInfo.remove();
    m_Spacer.remove();
}

/**************************************
class ApplicationInfoScene::CacheControl
**************************************/
/**
* コンストラクタ
*/
ApplicationInfoScene::CacheControl::CacheControl(const glv::Rect& rect) NN_NOEXCEPT
    : glv::Table("< > , . > , < > , < -", 0.f, 12.f)
    , m_Spacer(rect.w - DefaultRightPadding, 1.f)
    , m_LabelDataInfoCache("Server Cache", DefaultLabelSpec)
    , m_ButtonUpdateDataInfoCache("Update", nullptr, glv::Rect(DefaultButtonWidth, DefaultButtonHeight))
    , m_ButtonDeleteDataInfoCache("Delete", nullptr, glv::Rect(DefaultButtonWidth, DefaultButtonHeight))
    , m_LabelUpdateThumbnailCache("Update Thunbnail", DefaultLabelSpec)
    , m_ButtonUpdateThumbnailCache("Start", nullptr, glv::Rect(DefaultButtonWidth, DefaultButtonHeight))
{
    // サーバー情報キャッシュ更新
    m_ButtonUpdateDataInfoCache.SetCallback(
        [&]
        {
            // TODO:後で処理を追加する
        }
        );

    // サーバー情報キャッシュ削除
    m_ButtonDeleteDataInfoCache.SetCallback(
        [&]
        {
            // TODO:後で処理を追加する
        }
        );

    // サムネイルのダウンロード
    m_ButtonUpdateThumbnailCache.SetCallback(
        [&]
        {
            // TODO:後で処理を追加する
        }
        );
}

/**
* 更新
* TODO:セーブデータ/アプリケーションのキーを受け取る予定
*/
void ApplicationInfoScene::CacheControl::Refresh() NN_NOEXCEPT
{
    Clear();

    // 設定
    *this
        << m_LabelDataInfoCache
        << m_ButtonUpdateDataInfoCache
        << m_ButtonDeleteDataInfoCache
        << m_LabelUpdateThumbnailCache
        << m_ButtonUpdateThumbnailCache
        << m_Spacer;

    this->arrange();
}

/**
* クリア
*/
void ApplicationInfoScene::CacheControl::Clear() NN_NOEXCEPT
{
    // 一旦外す
    m_LabelDataInfoCache.remove();
    m_ButtonUpdateDataInfoCache.remove();
    m_ButtonDeleteDataInfoCache.remove();
    m_LabelUpdateThumbnailCache.remove();
    m_ButtonUpdateThumbnailCache.remove();
    m_Spacer.remove();
}

/**************************************
class ApplicationInfoScene::ServerControl
**************************************/
/**
* コンストラクタ
*/
ApplicationInfoScene::ServerControl::ServerControl(const glv::Rect& rect) NN_NOEXCEPT
    : glv::Table("< > , < -", 0.f, 12.f)
    , m_Spacer(rect.w - DefaultRightPadding, 1.f)
    , m_LabelDeleteBackupData("Delete BackupData", DefaultLabelSpec)
    , m_ButtonDeleteBackupData("Start", nullptr, glv::Rect(DefaultButtonWidth, DefaultButtonHeight))
{
    // サーバー情報キャッシュ更新
    m_ButtonDeleteBackupData.SetCallback(
        [&]
        {
            // TODO:後で処理を追加する
        }
        );
}

/**
* 更新
*/
void ApplicationInfoScene::ServerControl::Refresh() NN_NOEXCEPT
{
    Clear();

    // 設定
    *this
        << m_LabelDeleteBackupData
        << m_ButtonDeleteBackupData
        << m_Spacer;

    this->arrange();
}

/**
* クリア
*/
void ApplicationInfoScene::ServerControl::Clear() NN_NOEXCEPT
{
    // 一旦外す
    m_LabelDeleteBackupData.remove();
    m_ButtonDeleteBackupData.remove();
    m_Spacer.remove();
}


/**************************************
class ApplicationInfoScene
**************************************/
/**
* コンストラクタ
*/
ApplicationInfoScene::ApplicationInfoScene(ParentPageInterface* pParentPage, const glv::Rect& rect) NN_NOEXCEPT
    : Scene(rect)
    , m_pParentPage(pParentPage)
    , m_pButtonBack(nullptr)
    , m_LayoutTable("<", 0.f, 0.f, glv::Rect(rect.w, rect.h))
    , m_ScrollBoxView("<", glv::Rect(rect.w, rect.h))
    , m_SaveDataHeader(glv::Rect(rect.w, rect.h))
    , m_SaveDataDetailInfo(glv::Rect(rect.w - DefaultRightPadding, rect.h))
    , m_TaskControl(glv::Rect(rect.w - DefaultRightPadding, rect.h))
    , m_CacheControl(glv::Rect(rect.w - DefaultRightPadding, rect.h))
    , m_ServerControl(glv::Rect(rect.w - DefaultRightPadding, rect.h))
{
    // 戻るボタン
    m_pButtonBack = new Button("< Back",
        [&] {
            m_pParentPage->SwitchScene(SceneType_AccountInfo, true);
        }
        , glv::Rect(DefaultButtonWidth, DefaultButtonHeight));

    const glv::space_t headerWidth = rect.w - DefaultRightPadding;

    // タスク操作
    m_pTaskControlHeader = CreateCategoryHeader("Task Control", DefaultLabelSpec,
        glv::Rect(headerWidth, DefaultCategoryHeaderHeight));

    // キャッシュ操作
    m_pCacheControlHeader = CreateCategoryHeader("Cache Control", DefaultLabelSpec,
        glv::Rect(headerWidth, DefaultCategoryHeaderHeight));

    // サーバー操作
    m_pServerControlHeader = CreateCategoryHeader("Server Control", DefaultLabelSpec,
        glv::Rect(headerWidth, DefaultCategoryHeaderHeight));

    m_ScrollBoxView.enable(glv::Property::KeepWithinParent);

    m_LayoutTable << m_pButtonBack;
    m_LayoutTable.arrange();

    *this << m_LayoutTable;

    SetLastFocusedView(m_pButtonBack);
    SetFirstFocusTargetView(m_pButtonBack);
}

/**
* クリア
*/
void ApplicationInfoScene::Clear() NN_NOEXCEPT
{
    // フォーカスクリア
    auto& g = reinterpret_cast< glv::GLV& >(this->root());
    NN_ASSERT(glv::GLV::valid(&g));
    g.setFocus(nullptr);

    // 一旦remove
    m_SaveDataHeader.remove();
    m_SaveDataDetailInfo.remove();
    m_pTaskControlHeader->remove();
    m_TaskControl.remove();
    m_pCacheControlHeader->remove();
    m_CacheControl.remove();
    m_pServerControlHeader->remove();
    m_ServerControl.remove();

    m_ScrollBoxView.remove();
    m_ScrollBoxView.Refresh();

    m_LayoutTable.remove();
}

/**
* 更新
*/
void ApplicationInfoScene::Refresh() NN_NOEXCEPT
{
    Clear();
    ClearRefreshRequest();

    m_SaveDataHeader.Refresh();
    m_SaveDataDetailInfo.Refresh();
    m_TaskControl.Refresh();
    m_CacheControl.Refresh();
    m_ServerControl.Refresh();

    // ScrollBoxへは1つずつ入れる
    m_ScrollBoxView << m_SaveDataDetailInfo;
    m_ScrollBoxView << m_pTaskControlHeader;
    m_ScrollBoxView << m_TaskControl;
    m_ScrollBoxView << m_pCacheControlHeader;
    m_ScrollBoxView << m_CacheControl;
    m_ScrollBoxView << m_pServerControlHeader;
    m_ScrollBoxView << m_ServerControl;

    m_ScrollBoxView.SetRectAndUpdateInnerSize(w, h - (m_pButtonBack->h + m_SaveDataHeader.h));
    m_ScrollBoxView.ArrangeTable();

    m_LayoutTable
        << m_SaveDataHeader
        << m_ScrollBoxView;

    m_LayoutTable.arrange();

    *this << m_LayoutTable;

    auto& g = reinterpret_cast<glv::GLV&>(this->root());
    NN_ASSERT(glv::GLV::valid(&g));
    g.setFocus(GetFirstFocusTargetView());
}

/**
* 描画前コールバック
*/
void ApplicationInfoScene::OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT
{
    if (IsRefreshRequired())
    {
        Refresh();
    }
}

/**
* アクティブ処理
*/
void ApplicationInfoScene::OnActivatePage() NN_NOEXCEPT
{
    // 以下情報のすべてが存在する場合はRefresh、1つでも存在しない場合はルートに戻る
    // ・アカウント
    // ・アプリケーション
    // ・セーブデータ

    //auto getUserExistanceResult = nn::account::GetUserExistence(&isExist, m_Uid);
    bool isExisting = true;// TODO:後で修正予定
    if(isExisting == true)
    {
        Refresh();
    }
    else
    {
        m_pParentPage->SwitchScene(SceneType_CloudBackupRoot, true);
    }
}

/**
* シーンに入る際の遷移イベント
*/
void ApplicationInfoScene::OnEnterScene() NN_NOEXCEPT
{
    // スクロールを戻す
    m_ScrollBoxView.ScrollToTop();

    // フォーカスを先頭に設定しなおす
    auto& g = reinterpret_cast<glv::GLV&>(this->root());
    NN_ASSERT(glv::GLV::valid(&g));
    g.setFocus(GetFirstFocusTargetView());
}

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
