﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ns/ns_ApplicationViewApi.h>

#include "../DevMenu_RootSurface.h"
#include "DevMenu_ApplicationsConfig.h"

namespace devmenu { namespace application {

class AbstractOperators
{
public:
    virtual void ManageApplication( const nn::ncm::ApplicationId& applicationId ) const NN_NOEXCEPT = 0;
    virtual void SelectApplication( const nn::ns::ApplicationView& applicationView = application::InvalidApplicationView ) const NN_NOEXCEPT = 0;
    virtual void OpenApplicationInfo()                       const NN_NOEXCEPT = 0;
    virtual void CloseApplicationInfo()                      const NN_NOEXCEPT = 0;
    virtual void ShowLegalInfo( const char* kindOfDocument, const nn::ncm::ApplicationId& applicationId ) const NN_NOEXCEPT = 0;
    virtual void OpenAutoBootSetting()                       const NN_NOEXCEPT = 0;

    virtual RootSurfaceContext* GetRootSurfaceContext() const NN_NOEXCEPT = 0;
};

}} // ~namespace devmenu::application, ~namespace devmenu

