﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv_core.h>
#include <glv_caption.h>
#include <glv_layout.h>
#include <glv_texture.h>
#include <functional>
#include <nn/account/account_Types.h>
#include <nn/os/os_Mutex.h>

#include "DevMenu_AccountsConfig.h"
#include "DevMenu_AccountsUiPolicy.h"
#include "../DevMenu_Config.h"
#include "../Common/DevMenu_Buffer.h"

namespace devmenu { namespace accounts {

class Button
    : public glv::Button
{
private:
    glv::Label m_Label;
    std::function<void()> m_Callback;

public:
    Button(const std::string& label, std::function<void()> callback, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT
        : glv::Button(r, true)
        , m_Label(label, glv::Label::Spec(glv::Place::CC, 0.0f, 0.0f, CommonValue::InitialFontSize))
        , m_Callback(callback)
    {
        this->anchor( anchor );
        *this << m_Label;
        changePadClickDetectableButtons( glv::BasicPadEventType::Button::Ok::Mask );
        changePadClickDetectableButtons( glv::DebugPadEventType::Button::Ok::Mask );
        attach( []( const glv::Notification& n )->void { n.receiver< Button >()->m_Callback(); }, glv::Update::Clicked, this );
    }
};


class ToggleButton
    : public glv::View
{
private:
    Refreshable& m_Parent;
    glv::Label m_Label;
    glv::Label* m_pStatus;
    std::function<bool()> m_Getter;
    std::function<void(bool)> m_Setter;

    void UpdateStatus() NN_NOEXCEPT
    {
        if (m_pStatus != nullptr)
        {
            delete m_pStatus;
        }

        m_pStatus = new glv::Label(
            m_Getter()
                ? "o Enabled:"
                : "x Disabled:",
            glv::Label::Spec(glv::Place::CL, 16.0f, 0.0f, Default::FontSizeSmall));
        *this << m_pStatus;
    }

public:
    ToggleButton(const std::string& label, std::function<bool()> getter, std::function<void(bool)> setter, Refreshable& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT
        : glv::View(r, anchor)
        , m_Parent(parent)
        , m_Label(label, glv::Label::Spec(glv::Place::CL, 128.0f, 0.0f, Default::FontSize))
        , m_pStatus(nullptr)
        , m_Getter(getter)
        , m_Setter(setter)
    {
        *this << m_Label;
        Refresh();
#if 0
        glv::Style* pStyle = new glv::Style();
        pStyle->color.set(glv::StyleColor::BlackOnWhite);
        pStyle->color.fore.set(0.8, 0.8, 0.8);
        pStyle->color.back.set(0.0, 0.6, 0.0);
        style(pStyle);
        enable(glv::Property::DrawBack | glv::Property::DrawBorder);
#endif

        changePadClickDetectableButtons( glv::BasicPadEventType::Button::Ok::Mask );
        changePadClickDetectableButtons( glv::DebugPadEventType::Button::Ok::Mask );
        attach( []( const glv::Notification& n )->void
        {
            ToggleButton* const pToggleButton = n.receiver< ToggleButton >();
            pToggleButton->m_Parent.RequireRefresh();
            pToggleButton->m_Setter( !pToggleButton->m_Getter() );
        }, glv::Update::Clicked, this );
    }
    void Refresh() NN_NOEXCEPT
    {
        UpdateStatus();
    }
};

struct UserIcon
    : public glv::View
{
    mutable nn::os::Mutex m_Lock;
    glv::Texture2* m_pTexture;
    glv::space_t m_PadX;
    glv::space_t m_PadY;

    UserIcon(glv::GLsizei width, glv::GLsizei height, glv::space_t padX, glv::space_t padY) NN_NOEXCEPT;
    virtual ~UserIcon() NN_NOEXCEPT;
    void SetTexture(const Buffer& jpegData) NN_NOEXCEPT;
    void ClearTexture() NN_NOEXCEPT;
    virtual void onDraw(glv::GLV& g) NN_NOEXCEPT;

private:
    void ActivateTexture() NN_NOEXCEPT;
};

class UserButton
    : public glv::View
{
private:
    std::function<void()> m_Callback;

    glv::Placer m_Placer;
    class Validity
        : public glv::View
    {
    private:
        glv::Label m_Label;
        glv::Style m_Style;

    public:
        explicit Validity(bool validity) NN_NOEXCEPT;
    } * m_pValidity;
    UserIcon m_Icon;
    glv::Label* m_pNickname;

public:
    UserButton(const nn::account::Uid& uid, std::function<void()> callback, const glv::Rect& r) NN_NOEXCEPT;
    virtual ~UserButton() NN_NOEXCEPT NN_OVERRIDE;
    void SetVailidity(bool valid) NN_NOEXCEPT;
};

}} // ~namespace devmenu::accounts, ~namespace devmenu
