﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>

#include "DevMenu_AccountsUiComponents.h"
#include "../DevMenu_ModalView.h"

namespace devmenu { namespace accounts {

class UserAccountSelector
    : public devmenu::ModalView
{
    NN_DISALLOW_COPY(UserAccountSelector);
    NN_DISALLOW_MOVE(UserAccountSelector);

private:
    glv::Placer m_Placer;
    glv::Label m_Message;
    glv::Label m_Invalid;
    UserButton* m_Buttons[nn::account::UserCountMax];
    Button m_AddUserAccount;
    Button m_Cancel;
    bool m_IsAutoSelect;

public:
    UserAccountSelector(
        std::function<void(nn::account::Uid uid)> selectCallback,
        std::function<void()> cancelCallback,
        bool requiredWithNetworkServiceAccountAvailable,
        bool enableCancel,
        const char* headerText = "Select a user account with whom launch") NN_NOEXCEPT;
    virtual ~UserAccountSelector() NN_NOEXCEPT NN_OVERRIDE;
    bool IsAutoSelect() NN_NOEXCEPT { return m_IsAutoSelect; }
};

}} // ~namespace devmenu::accounts, ~namespace devmenu
