﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>

#include <glv_ScissorBoxView.h>
#include <nn/nn_Common.h>

#include "DevMenu_AccountsConfig.h"
#include "DevMenu_AccountsSdkHelper.h"
#include "DevMenu_AccountsUiComponents.h"
#include "../Common/DevMenu_CommonScene.h"

namespace devmenu { namespace accounts {

class DetailScene
    : public Scene
{
private:
    class Closer : public Button
    {
    private:
        const AbstractOperators& m_Op;
        void CloseEventCallback() NN_NOEXCEPT;
    public:
        Closer(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
    };

    class Buttons
        : public glv::View
    {
    private:
        glv::Placer m_Placer;

        class Deleter : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void DeleteEventCallback() NN_NOEXCEPT;
        public:
            Deleter(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_Deleter;

        class SaRegistrar : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void RegisrationCallback() NN_NOEXCEPT;
        public:
            SaRegistrar(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_SaRegistrar;

        class SaUnregistrar : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void UnregisrationCallback() NN_NOEXCEPT;
        public:
            SaUnregistrar(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_SaUnregistrar;

        class SaEnsurer : public Button
        {
        private:
            DetailScene& m_Parent;
            void EnsuranceCallback() NN_NOEXCEPT;
        public:
            SaEnsurer(DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_SaEnsurer;

        class SaProfileSync : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void SynchronizationCallback() NN_NOEXCEPT;
        public:
            SaProfileSync(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_SaProfileSync;

        class SaProfileUpload : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void UploadCallback() NN_NOEXCEPT;
        public:
            SaProfileUpload(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_SaProfileUpload;

        class SaNotificationTokenUpload : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void UploadCallback() NN_NOEXCEPT;
        public:
            SaNotificationTokenUpload(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_SaNotificationTokenUpload;

        class NaCacheUpdate : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void SynchronizationCallback() NN_NOEXCEPT;
        public:
            NaCacheUpdate(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_NaCacheUpdate;

        class NicknameSelector : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void SelectNicknameCallback() NN_NOEXCEPT;
        public:
            NicknameSelector(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
        } m_NicknameSelector;

        class ProfileImageSelector : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void SelectProfileImageCallback() NN_NOEXCEPT;
        public:
            ProfileImageSelector(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
        } m_ProfileImageSelector;

        class DebugCacheClearance : public Button
        {
        private:
            DetailScene& m_Parent;
            void SetCallback() NN_NOEXCEPT;
        public:
            DebugCacheClearance(DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_DebugIdTokenClearance;

        class DebugNaBadStatusSelector : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void SetBadStatusCallback() NN_NOEXCEPT;
        public:
            DebugNaBadStatusSelector(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_DebugNaBadStatusSelector;

        class PlayDataInfoViewer : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void SetCallback() NN_NOEXCEPT;
        public:
            PlayDataInfoViewer(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
        } m_PlayDataInfoViewer;

        class NaImplicitRecovery : public Button
        {
        private:
            const AbstractOperators& m_Op;
            DetailScene& m_Parent;
            void Callback() NN_NOEXCEPT;
        public:
            NaImplicitRecovery(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_NaImplicitRecovery;

    public:
        Buttons(const AbstractOperators& op, DetailScene& parent, const glv::Rect& r) NN_NOEXCEPT;
        void Clear() NN_NOEXCEPT;
        void Update() NN_NOEXCEPT;
    };

    class Detail : public glv::View
    {
    private:
        DetailScene& m_Parent;
        glv::Placer m_Placer;
        UserIcon m_Icon;

        class Name : public glv::View
        {
        private:
            Detail& m_Parent;
            glv::Placer m_Placer;
            glv::Label* m_pNickname;
            glv::Label* m_pUid;
        public:
            Name(Detail& parent, const glv::Rect& r) NN_NOEXCEPT;
            void Update() NN_NOEXCEPT;
        } m_Name;

    public:
        Detail(DetailScene& parent, const glv::Rect& r) NN_NOEXCEPT;
        void Update() NN_NOEXCEPT;
    };

    nn::account::Uid m_User;
    glv::ScissorBoxView m_Base;
    glv::Placer m_Placer;
    glv::Label m_Header;
    Closer m_Closer;
    glv::Table* m_pLayout;
    Detail m_Detail;
    Buttons m_Buttons;

public:
    DetailScene(const AbstractOperators& op, glv::Rect rect) NN_NOEXCEPT;
    ~DetailScene() NN_NOEXCEPT;

    glv::View* GetPrimaryView() NN_NOEXCEPT;

    void SetAccount(nn::account::Uid user) NN_NOEXCEPT;
    const nn::account::Uid &GetAccount() NN_NOEXCEPT;
    void Clear() NN_NOEXCEPT;
    void Refresh() NN_NOEXCEPT;

    nn::Result OnNicknameSelected(const NicknameSelection& selection) NN_NOEXCEPT;
    void OnProfileImageSelected(const char* name) NN_NOEXCEPT;
    void OnDebugUserBadStatusSelected(const nn::Result& result) NN_NOEXCEPT;
};

}} // ~namespace devmenu::accounts, ~namespace devmenu

