﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class View
{
public:
    explicit View();
    ~View();

    nn::Result DisplayWithLog(std::string logString);
    nn::Result DisplayWithError(std::string errorString);
};

enum ViewDisplayState {
    ViewDisplayState_Progress,
    ViewDisplayState_Error,
    ViewDisplayState_Finish,
    ViewDisplayState_Terminate,
    ViewDisplayState_Close,
    ViewDisplayState_Other,
};

nn::Result InitializeView();
nn::Result FinalizeView();
void ViewSetState(ViewDisplayState setState);
void ViewSetString(std::string setString);
void ViewErrorLog(std::string errorString);
void RebootMe();
