﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <cstring>
#include <memory>
#include <string>
#include <unordered_map>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/settings/factory/settings_ConfigurationId.h>
#include <nn/settings/fwdbg/settings_SettingsCommon.h>
#if 0
#include <nn/settings/system/settings_FirmwareVersion.h>
#endif
#include <nn/nn_Log.h>
#include "DevKitUpdater.h"

namespace
{
    const std::string SDEV_MP_STRING = "SDEV_00_02_00_00";
    const std::string EDEV_MP_STRING = "EDEV_00_03_00_00";

    std::unordered_map<std::string, std::string> DevKitTypeMap = {
        {"SDEV_00_01_08", "SDEV 1.8"},
        {"SDEV_00_01_09_01", "SDEV PreMP1"},
        {"SDEV_00_01_09_02", "SDEV PreMP2"},
        {SDEV_MP_STRING, "SDEV MP"},
        {"EDEV_00_02_00_01", "EDEV EP2-1"},
        {"EDEV_00_02_00_02", "EDEV EP2-2"},
        {EDEV_MP_STRING, "EDEV MP"},
    };

    const std::string DevKitTypeUnknown = "Unknown hardware";

#if !defined(DEVKIT_UPDATER_EDEVK5) && !defined(DEVKIT_UPDATER_EDEVK5UNSIGNED)
    bool IsSupportedSdev(std::string configId1)
    {
        return (configId1 == SDEV_MP_STRING);
    }
#endif

#if !defined(DEVKIT_UPDATER_SDEVK5) && !defined(DEVKIT_UPDATER_SDEVK5UNSIGNED)
    bool IsSupportedEdev(std::string configId1)
    {
        return (configId1 == EDEV_MP_STRING);
    }
#endif
}

bool CheckTargetInfomation(bool isBootFormPc)
{
    nn::settings::factory::ConfigurationId1 configurationId1;
    nn::settings::factory::GetConfigurationId1(&configurationId1);

#if defined(DEVKIT_UPDATER_SDEVK5) || defined(DEVKIT_UPDATER_SDEVK5UNSIGNED)
    if(!IsSupportedSdev(configurationId1.string))
    {
        std::string errorString = "[ERROR] Unsupport target.\nThis updater supports SDEV MP only.\n";
        ViewErrorLog(errorString);
        NN_LOG(errorString.c_str());
        auto search = DevKitTypeMap.find(configurationId1.string);
        NN_LOG("Target is %s\n", search != DevKitTypeMap.end() ? search->second.c_str() : DevKitTypeUnknown.c_str());
        return false;
    }
#elif defined(DEVKIT_UPDATER_EDEVK5) || defined(DEVKIT_UPDATER_EDEVK5UNSIGNED)
    if(!IsSupportedEdev(configurationId1.string))
    {
        std::string errorString = "[ERROR] Unsupport target.\nThis updater supports EDEV MP only.\n";
        ViewErrorLog(errorString);
        NN_LOG(errorString.c_str());
        auto search = DevKitTypeMap.find(configurationId1.string);
        NN_LOG("Target is %s\n", search != DevKitTypeMap.end() ? search->second.c_str() : DevKitTypeUnknown.c_str());
        return false;
    }
#elif defined(DEVKIT_UPDATER_NXK5PROD) || defined(DEVKIT_UPDATER_NXK5PRODLOG)
    if(!IsSupportedSdev(configurationId1.string) && !IsSupportedEdev(configurationId1.string))
    {
        std::string errorString = "[ERROR] Unsupport target.\nThis updater supports SDEV MP or EDEV MP.\n";
        ViewErrorLog(errorString);
        NN_LOG(errorString.c_str());
        auto search = DevKitTypeMap.find(configurationId1.string);
        NN_LOG("Target is %s\n", search != DevKitTypeMap.end() ? search->second.c_str() : DevKitTypeUnknown.c_str());
        return false;
    }
#endif

#if defined(DEVKIT_UPDATER_NXK5PROD) || defined(DEVKIT_UPDATER_NXK5PRODLOG)
    if(nn::settings::fwdbg::IsDebugModeEnabled())
    {
        std::string errorString = "[ERROR] Unsupport mode.\nThis updater must use on PROD MODE firmware.\n";
        ViewErrorLog(errorString);
        NN_LOG(errorString.c_str());
        return false;
    }
#else
    if(!nn::settings::fwdbg::IsDebugModeEnabled())
    {
        std::string errorString = "[ERROR] Unsupport mode.\nThis updater must use on DEV MODE firmware.\n";
        ViewErrorLog(errorString);
        NN_LOG(errorString.c_str());
        return false;
    }
#endif

#if defined(DEVKIT_UPDATER_SDEVK5) || defined(DEVKIT_UPDATER_SDEVK5UNSIGNED)
    if(!isBootFormPc)
    {
        std::string errorString = "[ERROR] This updater does not support card boot.\nPlease use SystemUpdateSdev.exe\n";
        ViewErrorLog(errorString);
        NN_LOG(errorString.c_str());
        return false;
    }
#endif

#if 0
    const uint8_t FirmwareMajorVersion_Minimum = 4;
    nn::settings::system::FirmwareVersion version;
    nn::settings::system::GetFirmwareVersion( &version );
    if(version.major < FirmwareMajorVersion_Minimum)
    {
        std::string errorString = "This updater supports after NX Addon 4.0\n";
        ViewErrorLog(errorString);
        NN_LOG(errorString.c_str());
        return false;
    }
#endif

    return true;
}

