﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>

#include "ControllerSerialFlashTool_ParserType.h"

struct SerialFlashEntityType
{
    std::string category;
    std::string name;
    SerialFlashParserType parser;
};

inline SerialFlashEntityType ReservedSerialFlashEntity(int size)
{
    return
    {
        "Reserved", "", ReservedParserType(size)
    };
};

const int SerialFlashStartAddress = 0x6000;
const int SerialFlashSize         = 4096 * 3;

const SerialFlashEntityType SerialFlashMap[] =
{
    { "Identification Code",            "",                          IdentificationCodeParserType },
    ReservedSerialFlashEntity(2),
    { "Device Type",                    "",                          u8ParserType },
    { "Board Revision",                 "",                          u8ParserType },
    ReservedSerialFlashEntity(7),
    { "Format Version",                 "",                          u8ParserType },
    ReservedSerialFlashEntity(4),
    { "Accelerometer 0 offset",         "X",                         s16ParserType },
    { "Accelerometer 0 offset",         "Y",                         s16ParserType },
    { "Accelerometer 0 offset",         "Z",                         s16ParserType },
    { "Accelerometer 1G scale",         "X",                         s16ParserType },
    { "Accelerometer 1G scale",         "Y",                         s16ParserType },
    { "Accelerometer 1G scale",         "Z",                         s16ParserType },
    { "Gyroscope 0 offset",             "X",                         s16ParserType },
    { "Gyroscope 0 offset",             "Y",                         s16ParserType },
    { "Gyroscope 0 offset",             "Z",                         s16ParserType },
    { "Gyroscope 78rpm scale",          "X",                         s16ParserType },
    { "Gyroscope 78rpm scale",          "Y",                         s16ParserType },
    { "Gyroscope 78rpm scale",          "Z",                         s16ParserType },
    ReservedSerialFlashEntity(5),
    { "Analog Stick Main Cal",          "X+",                        u12HigherParserType },
    { "Analog Stick Main Cal",          "Y+",                        u12LowerParserType },
    { "Analog Stick Main Cal",          "X0",                        u12HigherParserType },
    { "Analog Stick Main Cal",          "Y0",                        u12LowerParserType },
    { "Analog Stick Main Cal",          "X-",                        u12HigherParserType },
    { "Analog Stick Main Cal",          "Y-",                        u12LowerParserType },
    { "Analog Stick Sub Cal",           "X+",                        u12HigherParserType },
    { "Analog Stick Sub Cal",           "Y+",                        u12LowerParserType },
    { "Analog Stick Sub Cal",           "X0",                        u12HigherParserType },
    { "Analog Stick Sub Cal",           "Y0",                        u12LowerParserType },
    { "Analog Stick Sub Cal",           "X-",                        u12HigherParserType },
    { "Analog Stick Sub Cal",           "Y-",                        u12LowerParserType },
    ReservedSerialFlashEntity(1),
    { "Main Color",                     "R",                         u8ParserType },
    { "Main Color",                     "G",                         u8ParserType },
    { "Main Color",                     "B",                         u8ParserType },
    { "Sub Color",                      "R",                         u8ParserType },
    { "Sub Color",                      "G",                         u8ParserType },
    { "Sub Color",                      "B",                         u8ParserType },
    { "3rd Color",                      "R",                         u8ParserType },
    { "3rd Color",                      "G",                         u8ParserType },
    { "3rd Color",                      "B",                         u8ParserType },
    { "4th Color",                      "R",                         u8ParserType },
    { "4th Color",                      "G",                         u8ParserType },
    { "4th Color",                      "B",                         u8ParserType },
    { "Variation",                      "",                          u8ParserType },
    ReservedSerialFlashEntity(35),
    { "6-axis horizontal offset",       "X",                         s16ParserType },
    { "6-axis horizontal offset",       "Y",                         s16ParserType },
    { "6-axis horizontal offset",       "Z",                         s16ParserType },
    { "Analog Stick Main Model",        "Noise",                     u12HigherParserType },
    { "Analog Stick Main Model",        "Typical Stroke",            u12LowerParserType },
    { "Analog Stick Main Model",        "Center Dead Zone Size",     u12HigherParserType },
    { "Analog Stick Main Model",        "Circuit Dead Zone Scale",   u12LowerParserType },
    { "Analog Stick Main Model",        "Minimum Stroke X+",         u12HigherParserType },
    { "Analog Stick Main Model",        "Minimum Stroke Y+",         u12LowerParserType },
    { "Analog Stick Main Model",        "Minimum Stroke X-",         u12HigherParserType },
    { "Analog Stick Main Model",        "Minimum Stroke Y-",         u12LowerParserType },
    { "Analog Stick Main Model",        "Center Range X+",           u12HigherParserType },
    { "Analog Stick Main Model",        "Center Range Y+",           u12LowerParserType },
    { "Analog Stick Main Model",        "Center Range X-",           u12HigherParserType },
    { "Analog Stick Main Model",        "Center Range Y-",           u12LowerParserType },
    { "Analog Stick Sub Model",         "Noise",                     u12HigherParserType },
    { "Analog Stick Sub Model",         "Typical Stroke",            u12LowerParserType },
    { "Analog Stick Sub Model",         "Center Dead Zone Size",     u12HigherParserType },
    { "Analog Stick Sub Model",         "Circuit Dead Zone Scale",   u12LowerParserType },
    { "Analog Stick Sub Model",         "Minimum Stroke X+",         u12HigherParserType },
    { "Analog Stick Sub Model",         "Minimum Stroke Y+",         u12LowerParserType },
    { "Analog Stick Sub Model",         "Minimum Stroke X-",         u12HigherParserType },
    { "Analog Stick Sub Model",         "Minimum Stroke Y-",         u12LowerParserType },
    { "Analog Stick Sub Model",         "Center Range X+",           u12HigherParserType },
    { "Analog Stick Sub Model",         "Center Range Y+",           u12LowerParserType },
    { "Analog Stick Sub Model",         "Center Range X-",           u12HigherParserType },
    { "Analog Stick Sub Model",         "Center Range Y-",           u12LowerParserType},
    ReservedSerialFlashEntity(1),
    { "Accelerometer",                  "Axis Assignment",           u8ParserType},
    { "Gyroscope",                      "Axis Assignment",           u8ParserType},
    { "Analog Stick Main",              "Axis Assignment",           u8ParserType},
    { "Analog Stick Sub",               "Axis Assignment",           u8ParserType},
    ReservedSerialFlashEntity(3281),
    { "Tarragon",                       "Vid",                       u16ParserType },
    { "Tarragon",                       "Pid",                       u16ParserType},
    ReservedSerialFlashEntity(636),
    ReservedSerialFlashEntity(4096),
    ReservedSerialFlashEntity(16),
    { "Analog Stick Main User",         "MagicNumber",               u16ParserType },
    { "Analog Stick Main User",         "X+",                        u12HigherParserType },
    { "Analog Stick Main User",         "Y+",                        u12LowerParserType },
    { "Analog Stick Main User",         "X0",                        u12HigherParserType },
    { "Analog Stick Main User",         "Y0",                        u12LowerParserType },
    { "Analog Stick Main User",         "X-",                        u12HigherParserType },
    { "Analog Stick Main User",         "Y-",                        u12LowerParserType },
    { "Analog Stick Main User",         "MagicNumber",               u16ParserType },
    { "Analog Stick Sub User",          "X+",                        u12HigherParserType },
    { "Analog Stick Sub User",          "Y+",                        u12LowerParserType },
    { "Analog Stick Sub User",          "X0",                        u12HigherParserType },
    { "Analog Stick Sub User",          "Y0",                        u12LowerParserType },
    { "Analog Stick Sub User",          "X-",                        u12HigherParserType },
    { "Analog Stick Sub User",          "Y-",                        u12LowerParserType },
    { "SixAxis User Calibration",       "MagicNumber",               u16ParserType },
    { "Accelerometer 0 offset User",    "X",                         s16ParserType },
    { "Accelerometer 0 offset User",    "Y",                         s16ParserType },
    { "Accelerometer 0 offset User",    "Z",                         s16ParserType },
    { "Accelerometer 1G scale User",    "X",                         s16ParserType },
    { "Accelerometer 1G scale User",    "Y",                         s16ParserType },
    { "Accelerometer 1G scale User",    "Z",                         s16ParserType },
    { "Gyroscope 0 offset User",        "X",                         s16ParserType },
    { "Gyroscope 0 offset User",        "Y",                         s16ParserType },
    { "Gyroscope 0 offset User",        "Z",                         s16ParserType },
    { "Gyroscope 78rpm scale User",     "X",                         s16ParserType },
    { "Gyroscope 78rpm scale User",     "Y",                         s16ParserType },
    { "Gyroscope 78rpm scale User",     "Z",                         s16ParserType },
};
